/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.hessian;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.format.hessian.HessianUtils;
import org.apache.synapse.util.SynapseBinaryDataSource;

public class HessianMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(HessianMessageFormatter.class);

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String contentType = (String)msgCtxt.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = "x-application/hessian";
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start writing the message to OutputStream");
        }
        if (msgCtxt.getFLOW() == 4 || msgCtxt.getEnvelope().hasFault()) {
            try {
                SOAPFault fault = msgCtxt.getEnvelope().getBody().getFault();
                String hessianFaultDetail = "";
                String hessianFaultMessage = "";
                String hessianFaultCode = "500";
                if (fault.getDetail() != null) {
                    hessianFaultDetail = fault.getDetail().getText();
                }
                if (fault.getReason() != null) {
                    hessianFaultMessage = fault.getReason().getText();
                }
                if (fault.getCode() != null) {
                    hessianFaultCode = fault.getCode().getText();
                }
                BufferedOutputStream faultOutStream = new BufferedOutputStream(out);
                HessianUtils.writeFault(hessianFaultCode, hessianFaultMessage, hessianFaultDetail, faultOutStream);
                faultOutStream.flush();
                faultOutStream.close();
            }
            catch (IOException e) {
                this.handleException("Unalbe to write the fault as a hessian message", e);
            }
        } else {
            OMText hessianOMText = null;
            OMElement omElement = msgCtxt.getEnvelope().getBody().getFirstElement();
            Iterator it = omElement.getChildren();
            while (it.hasNext()) {
                OMText tempNode;
                OMNode hessianElement = (OMNode)it.next();
                if (!(hessianElement instanceof OMText) || (tempNode = (OMText)hessianElement).getDataHandler() == null || !(((DataHandler)tempNode.getDataHandler()).getDataSource() instanceof SynapseBinaryDataSource)) continue;
                hessianOMText = tempNode;
            }
            if (hessianOMText != null) {
                try {
                    int byteCount;
                    SynapseBinaryDataSource synapseBinaryDataSource = (SynapseBinaryDataSource)((DataHandler)hessianOMText.getDataHandler()).getDataSource();
                    InputStream inputStream = synapseBinaryDataSource.getInputStream();
                    BufferedOutputStream outputStream = new BufferedOutputStream(out);
                    byte[] buffer = new byte[1024];
                    while ((byteCount = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, byteCount);
                    }
                    inputStream.close();
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    this.handleException("Couldn't get the bytes from the HessianDataSource", e);
                }
            } else {
                this.handleException("Unable to find the hessian content in the payload");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Writing message as a hessian message is successful");
        }
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        throw new AxisFault("Method not supported. Use the HessianMessageFormatter#writeTo method instead");
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        return URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
    }

    private void handleException(String msg, Throwable e) throws AxisFault {
        log.error((Object)msg, e);
        throw new AxisFault(msg, e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

