/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.util.Map;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;

public class SynapseXPathVariableContext
implements VariableContext {
    private final VariableContext parent;
    private final MessageContext synCtx;
    private final SOAPEnvelope env;

    public SynapseXPathVariableContext(VariableContext parent, MessageContext synCtx) {
        this.parent = parent;
        this.synCtx = synCtx;
        this.env = synCtx.getEnvelope();
    }

    public SynapseXPathVariableContext(VariableContext parent, SOAPEnvelope env) {
        this.parent = parent;
        this.synCtx = null;
        this.env = env;
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (namespaceURI == null) {
            if (this.env != null) {
                if ("body".equals(localName)) {
                    return this.env.getBody();
                }
                if ("header".equals(localName)) {
                    return this.env.getHeader();
                }
            }
            if (prefix != null && !"".equals(prefix) && this.synCtx != null) {
                org.apache.axis2.context.MessageContext axis2MessageContext;
                Object headers;
                if ("ctx".equals(prefix)) {
                    return this.synCtx.getProperty(localName);
                }
                if ("axis2".equals(prefix)) {
                    return ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty(localName);
                }
                if ("trp".equals(prefix) && (headers = (axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map) {
                    Map headersMap = (Map)headers;
                    return headersMap.get(localName);
                }
            }
        }
        return this.parent.getVariableValue(namespaceURI, prefix, localName);
    }
}

