/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.util.List;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPathFunctionContext;
import org.apache.synapse.util.xpath.SynapseXPathVariableContext;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.VariableContext;
import org.jaxen.util.SingletonList;

public class SynapseXPath
extends AXIOMXPath {
    private static final long serialVersionUID = 7639226137534334222L;
    private static final Log log = LogFactory.getLog(SynapseXPath.class);

    public SynapseXPath(String xpathString) throws JaxenException {
        super(xpathString);
    }

    public String stringValueOf(MessageContext synCtx) {
        try {
            Object result = this.evaluate(synCtx);
            if (result == null) {
                return null;
            }
            StringBuffer textValue = new StringBuffer();
            if (result instanceof List) {
                List list = (List)result;
                for (Object o : list) {
                    if (o == null && list.size() == 1) {
                        return null;
                    }
                    if (o instanceof OMTextImpl) {
                        textValue.append(((OMTextImpl)o).getText());
                        continue;
                    }
                    if (o instanceof OMElementImpl) {
                        String s = ((OMElementImpl)o).getText();
                        if (s.trim().length() == 0) {
                            s = o.toString();
                        }
                        textValue.append(s);
                        continue;
                    }
                    if (!(o instanceof OMDocumentImpl)) continue;
                    textValue.append(((OMDocumentImpl)o).getOMDocumentElement().toString());
                }
            } else {
                textValue.append(result.toString());
            }
            return textValue.toString();
        }
        catch (JaxenException je) {
            this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", je);
            return null;
        }
    }

    public void addNamespace(OMNamespace ns) throws JaxenException {
        this.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
    }

    protected Context getContext(Object obj) {
        if (obj instanceof MessageContext) {
            MessageContext synCtx = (MessageContext)obj;
            ContextSupport baseContextSupport = this.getContextSupport();
            ContextSupport contextSupport = new ContextSupport(baseContextSupport.getNamespaceContext(), (FunctionContext)new SynapseXPathFunctionContext(baseContextSupport.getFunctionContext(), synCtx), (VariableContext)new SynapseXPathVariableContext(baseContextSupport.getVariableContext(), synCtx), baseContextSupport.getNavigator());
            Context context = new Context(contextSupport);
            context.setNodeSet((List)new SingletonList((Object)synCtx.getEnvelope()));
            return context;
        }
        if (obj instanceof SOAPEnvelope) {
            SOAPEnvelope env = (SOAPEnvelope)obj;
            ContextSupport baseContextSupport = this.getContextSupport();
            ContextSupport contextSupport = new ContextSupport(baseContextSupport.getNamespaceContext(), baseContextSupport.getFunctionContext(), (VariableContext)new SynapseXPathVariableContext(baseContextSupport.getVariableContext(), env), baseContextSupport.getNavigator());
            Context context = new Context(contextSupport);
            context.setNodeSet((List)new SingletonList((Object)env));
            return context;
        }
        return super.getContext(obj);
    }

    private void handleException(String msg, Throwable e) {
        log.error((Object)msg, e);
        throw new SynapseException(msg, e);
    }
}

