/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.TemporaryData;

public class SynapseBinaryDataSource
implements DataSource {
    private String contentType;
    private TemporaryData data;

    public SynapseBinaryDataSource(InputStream inputstream, String contentType) throws IOException {
        this.contentType = contentType;
        this.data = new TemporaryData(4, 1024, "tmp_", ".dat");
        this.data.readFrom(inputstream);
        inputstream.close();
    }

    public SynapseBinaryDataSource(InputStream inputstream, String contentType, SynapseEnvironment synEnv) throws IOException {
        this.contentType = contentType;
        this.data = synEnv.createTemporaryData();
        this.data.readFrom(inputstream);
        inputstream.close();
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return this.data.getInputStream();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.data.getOutputStream();
    }
}

