/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class RMIRegistryController {
    public static final Log log = LogFactory.getLog(RMIRegistryController.class);
    private static RMIRegistryController ourInstance = new RMIRegistryController();
    private Registry localRegistry;
    private boolean weCreatedRMIReg = false;

    public static RMIRegistryController getInstance() {
        return ourInstance;
    }

    private RMIRegistryController() {
    }

    public void createLocalRegistry(int port) {
        try {
            this.localRegistry = LocateRegistry.createRegistry(port);
        }
        catch (RemoteException e) {
            String msg = "Couldn't create a local registry(RMI) : port " + port + " already in use.";
            RMIRegistryController.handleException(msg, e);
        }
    }

    public void removeLocalRegistry() {
        if (this.localRegistry != null) {
            try {
                log.info((Object)"Removing the RMI registy instance from the RMI runtime ");
                UnicastRemoteObject.unexportObject(this.localRegistry, true);
            }
            catch (NoSuchObjectException e) {
                String msg = "Error when stoping localregistry(RMI)";
                RMIRegistryController.handleException(msg, e);
            }
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

