/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.RMIRegistryController;

public class DataSourceRegistrar {
    public static final Log log = LogFactory.getLog(DataSourceRegistrar.class);
    private static final String PROP_ICFACTORY = "icFactory";
    private static final String PROP_PROVIDER_URL = "providerUrl";
    private static final String PROP_PROVIDER_PORT = "providerPort";
    private static final String DOT_STRING = ".";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_DRIVER_CLS_NAME = "driverClassName";
    private static final String PROP_DSNAME = "dsName";
    private static final String PROP_URL = "url";
    private static final String PROP_DRIVER = "driver";
    private static final String PROP_USER = "user";
    private static final String PROP_CPDSADAPTER = "cpdsadapter";
    private static final String PROP_JNDI_ENV = "jndiEnvironment";
    private static final String PROP_DEFAULTMAXACTIVE = "defaultMaxActive";
    private static final String PROP_DEFAULTMAXIDLE = "defaultMaxIdle";
    private static final String PROP_DEFAULTMAXWAIT = "defaultMaxWait";
    private static final String PROP_DATA_SOURCE_NAME = "dataSourceName";
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_MAXACTIVE = "maxActive";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MAXWAIT = "maxWait";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALSIZE = "initialSize";
    private static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVEABANDONED = "removeAbandoned";
    private static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";

    public static void registerDataSources(Properties dsProperties) {
        if (dsProperties == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DataSource properties cannot be found..");
            }
            return;
        }
        String dataSources = DataSourceRegistrar.getProperty(dsProperties, "synapse.datasources", null);
        if (dataSources == null || "".equals(dataSources)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No DataSources defined for initialization..");
            }
            return;
        }
        String[] dataSourcesNames = dataSources.split(",");
        if (dataSourcesNames == null || dataSourcesNames.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No DataSource definitions found for initialization..");
            }
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("synapse.datasources");
        buffer.append(DOT_STRING);
        String rootPrefix = buffer.toString();
        Hashtable<String, String> props = new Hashtable<String, String>();
        Properties jndiEvn = new Properties();
        String namingFactory = DataSourceRegistrar.getProperty(dsProperties, rootPrefix + PROP_ICFACTORY, "com.sun.jndi.rmi.registry.RegistryContextFactory");
        props.put("java.naming.factory.initial", namingFactory);
        jndiEvn.put("java.naming.factory.initial", namingFactory);
        String providerHost = "localhost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                String hostname = addr.getHostName();
                if (hostname == null) {
                    String ipAddr = addr.getHostAddress();
                    if (ipAddr != null) {
                        providerHost = ipAddr;
                    }
                } else {
                    providerHost = hostname;
                }
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to determine hostname or IP address.. Using localhost", (Throwable)e);
        }
        int port = 2199;
        String providerPort = DataSourceRegistrar.getProperty(dsProperties, rootPrefix + PROP_PROVIDER_PORT, String.valueOf(port));
        try {
            port = Integer.parseInt(providerPort);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        RMIRegistryController.getInstance().createLocalRegistry(port);
        String providerUrl = DataSourceRegistrar.getProperty(dsProperties, rootPrefix + PROP_PROVIDER_URL, "rmi://" + providerHost + ":" + providerPort);
        props.put("java.naming.provider.url", providerUrl);
        jndiEvn.put("java.naming.provider.url", providerUrl);
        log.info((Object)("DataSources will be registered in the JNDI context with provider PROP_URL : " + providerUrl));
        try {
            InitialContext initialContext = new InitialContext(props);
            for (int i = 0; i < dataSourcesNames.length; ++i) {
                DataSourceRegistrar.registerDataSource(dataSourcesNames[i], dsProperties, initialContext, jndiEvn);
            }
        }
        catch (NamingException e) {
            String msg = "Error constructing an InitialContext to register DataSources";
            DataSourceRegistrar.handleException(msg, e);
        }
    }

    private static void registerDataSource(String dsName, Properties dsProperties, InitialContext initialContext, Properties jndiEnv) {
        String url;
        if (dsName == null || "".equals(dsName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DataSource name is either empty or null, ignoring..");
            }
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("synapse.datasources");
        buffer.append(DOT_STRING);
        buffer.append(dsName);
        buffer.append(DOT_STRING);
        String prefix = buffer.toString();
        String driver = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_DRIVER_CLS_NAME, null);
        if (driver == null) {
            DataSourceRegistrar.handleException(prefix + PROP_DRIVER_CLS_NAME + " cannot be found.");
        }
        if ((url = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_URL, null)) == null) {
            DataSourceRegistrar.handleException(prefix + PROP_URL + " cannot be found.");
        }
        String user = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_USER_NAME, "synapse");
        String password = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_PASSWORD, "synapse");
        String dataSourceName = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_DSNAME, dsName);
        DataSourceRegistrar.populateContextTree(initialContext, dataSourceName);
        String dsType = DataSourceRegistrar.getProperty(dsProperties, prefix + "type", "BasicDataSource");
        String maxActive = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_MAXACTIVE, String.valueOf(8));
        String maxIdle = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_MAXIDLE, String.valueOf(8));
        String maxWait = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_MAXWAIT, String.valueOf(-1L));
        if ("BasicDataSource".equals(dsType)) {
            Reference ref = new Reference("javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null);
            ref.add(new StringRefAddr(PROP_DRIVER_CLS_NAME, driver));
            ref.add(new StringRefAddr(PROP_URL, url));
            ref.add(new StringRefAddr(PROP_USER_NAME, user));
            ref.add(new StringRefAddr(PROP_PASSWORD, password));
            ref.add(new StringRefAddr(PROP_MAXACTIVE, maxActive));
            ref.add(new StringRefAddr(PROP_MAXIDLE, maxIdle));
            ref.add(new StringRefAddr(PROP_MAXWAIT, maxWait));
            DataSourceRegistrar.setBasicDataSourceParameters(ref, dsProperties, prefix);
            DataSourceRegistrar.setCommonParameters(ref, dsProperties, prefix);
            try {
                initialContext.rebind(dataSourceName, (Object)ref);
            }
            catch (NamingException e) {
                String msg = " Error binding name ' " + dataSourceName + " ' to " + "the DataSource(BasicDataSource) reference";
                DataSourceRegistrar.handleException(msg, e);
            }
        } else if ("PerUserPoolDataSource".equals(dsType)) {
            String className = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_CPDSADAPTER + DOT_STRING + "className", "org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
            String factory = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_CPDSADAPTER + DOT_STRING + "factory", "org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
            String name = DataSourceRegistrar.getProperty(dsProperties, prefix + PROP_CPDSADAPTER + DOT_STRING + "name", "cpds");
            Reference cpdsRef = new Reference(className, factory, null);
            cpdsRef.add(new StringRefAddr(PROP_DRIVER, driver));
            cpdsRef.add(new StringRefAddr(PROP_URL, url));
            cpdsRef.add(new StringRefAddr(PROP_USER, user));
            cpdsRef.add(new StringRefAddr(PROP_PASSWORD, password));
            try {
                initialContext.rebind(name, (Object)cpdsRef);
            }
            catch (NamingException e) {
                String msg = "Error binding name '" + name + "' to " + "the DriverAdapterCPDS reference";
                DataSourceRegistrar.handleException(msg, e);
            }
            Reference ref = new Reference("org.apache.commons.dbcp.datasources.PerUserPoolDataSource", "org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory", null);
            ref.add(new BinaryRefAddr(PROP_JNDI_ENV, DataSourceRegistrar.serialize(jndiEnv)));
            ref.add(new StringRefAddr(PROP_DATA_SOURCE_NAME, name));
            ref.add(new StringRefAddr(PROP_DEFAULTMAXACTIVE, maxActive));
            ref.add(new StringRefAddr(PROP_DEFAULTMAXIDLE, maxIdle));
            ref.add(new StringRefAddr(PROP_DEFAULTMAXWAIT, maxWait));
            DataSourceRegistrar.setCommonParameters(ref, dsProperties, prefix);
            try {
                initialContext.rebind(dataSourceName, (Object)ref);
            }
            catch (NamingException e) {
                String msg = "Error binding name ' " + dataSourceName + " ' to " + "the PerUserPoolDataSource reference";
                DataSourceRegistrar.handleException(msg, e);
            }
        } else {
            DataSourceRegistrar.handleException("Unsupported data source type : " + dsType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Object data) {
        ObjectOutputStream outputStream = null;
        ByteArrayOutputStream binOut = null;
        byte[] result = null;
        try {
            binOut = new ByteArrayOutputStream();
            outputStream = new ObjectOutputStream(binOut);
            outputStream.writeObject(data);
            result = binOut.toByteArray();
        }
        catch (IOException e) {
            DataSourceRegistrar.handleException("Error serializing object :" + data);
        }
        finally {
            if (binOut != null) {
                try {
                    binOut.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }

    private static void setCommonParameters(Reference reference, Properties properties, String prefix) {
        String defaultAutoCommit = DataSourceRegistrar.getProperty(properties, prefix + PROP_DEFAULTAUTOCOMMIT, String.valueOf(true));
        String defaultReadOnly = DataSourceRegistrar.getProperty(properties, prefix + PROP_DEFAULTREADONLY, String.valueOf(false));
        String testOnBorrow = DataSourceRegistrar.getProperty(properties, prefix + PROP_TESTONBORROW, String.valueOf(true));
        String testOnReturn = DataSourceRegistrar.getProperty(properties, prefix + PROP_TESTONRETURN, String.valueOf(false));
        String timeBetweenEvictionRunsMillis = DataSourceRegistrar.getProperty(properties, prefix + PROP_TIMEBETWEENEVICTIONRUNSMILLIS, String.valueOf(-1L));
        String numTestsPerEvictionRun = DataSourceRegistrar.getProperty(properties, prefix + PROP_NUMTESTSPEREVICTIONRUN, String.valueOf(3));
        String minEvictableIdleTimeMillis = DataSourceRegistrar.getProperty(properties, prefix + PROP_MINEVICTABLEIDLETIMEMILLIS, String.valueOf(1800000L));
        String testWhileIdle = DataSourceRegistrar.getProperty(properties, prefix + PROP_TESTWHILEIDLE, String.valueOf(false));
        String validationQuery = DataSourceRegistrar.getProperty(properties, prefix + PROP_VALIDATIONQUERY, null);
        reference.add(new StringRefAddr(PROP_DEFAULTAUTOCOMMIT, defaultAutoCommit));
        reference.add(new StringRefAddr(PROP_DEFAULTREADONLY, defaultReadOnly));
        reference.add(new StringRefAddr(PROP_TESTONBORROW, testOnBorrow));
        reference.add(new StringRefAddr(PROP_TESTONRETURN, testOnReturn));
        reference.add(new StringRefAddr(PROP_TIMEBETWEENEVICTIONRUNSMILLIS, timeBetweenEvictionRunsMillis));
        reference.add(new StringRefAddr(PROP_NUMTESTSPEREVICTIONRUN, numTestsPerEvictionRun));
        reference.add(new StringRefAddr(PROP_MINEVICTABLEIDLETIMEMILLIS, minEvictableIdleTimeMillis));
        reference.add(new StringRefAddr(PROP_TESTWHILEIDLE, testWhileIdle));
        if (validationQuery != null && !"".equals(validationQuery)) {
            reference.add(new StringRefAddr(PROP_VALIDATIONQUERY, validationQuery));
        }
    }

    private static void setBasicDataSourceParameters(Reference reference, Properties properties, String prefix) {
        String minIdle = DataSourceRegistrar.getProperty(properties, prefix + PROP_MINIDLE, String.valueOf(0));
        String initialSize = DataSourceRegistrar.getProperty(properties, prefix + PROP_INITIALSIZE, String.valueOf(0));
        String defaultTransactionIsolation = DataSourceRegistrar.getProperty(properties, prefix + PROP_DEFAULTTRANSACTIONISOLATION, null);
        String defaultCatalog = DataSourceRegistrar.getProperty(properties, prefix + PROP_DEFAULTCATALOG, null);
        String accessToUnderlyingConnectionAllowed = DataSourceRegistrar.getProperty(properties, prefix + PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED, String.valueOf(false));
        String removeAbandoned = DataSourceRegistrar.getProperty(properties, prefix + PROP_REMOVEABANDONED, String.valueOf(false));
        String removeAbandonedTimeout = DataSourceRegistrar.getProperty(properties, prefix + PROP_REMOVEABANDONEDTIMEOUT, String.valueOf(300));
        String logAbandoned = DataSourceRegistrar.getProperty(properties, prefix + PROP_LOGABANDONED, String.valueOf(false));
        String poolPreparedStatements = DataSourceRegistrar.getProperty(properties, prefix + PROP_POOLPREPAREDSTATEMENTS, String.valueOf(false));
        String maxOpenPreparedStatements = DataSourceRegistrar.getProperty(properties, prefix + PROP_MAXOPENPREPAREDSTATEMENTS, String.valueOf(-1));
        reference.add(new StringRefAddr(PROP_MINIDLE, minIdle));
        if (defaultTransactionIsolation != null && !"".equals(defaultTransactionIsolation)) {
            reference.add(new StringRefAddr(PROP_DEFAULTTRANSACTIONISOLATION, defaultTransactionIsolation));
        }
        reference.add(new StringRefAddr(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED, accessToUnderlyingConnectionAllowed));
        reference.add(new StringRefAddr(PROP_REMOVEABANDONED, removeAbandoned));
        reference.add(new StringRefAddr(PROP_REMOVEABANDONEDTIMEOUT, removeAbandonedTimeout));
        reference.add(new StringRefAddr(PROP_LOGABANDONED, logAbandoned));
        reference.add(new StringRefAddr(PROP_POOLPREPAREDSTATEMENTS, poolPreparedStatements));
        reference.add(new StringRefAddr(PROP_MAXOPENPREPAREDSTATEMENTS, maxOpenPreparedStatements));
        reference.add(new StringRefAddr(PROP_INITIALSIZE, initialSize));
        if (defaultCatalog != null && !"".equals(defaultCatalog)) {
            reference.add(new StringRefAddr(PROP_DEFAULTCATALOG, defaultCatalog));
        }
    }

    private static void populateContextTree(InitialContext initialContext, String path) {
        String[] paths = path.split("/");
        if (paths != null && paths.length > 1) {
            Context context = initialContext;
            for (int i = 0; i < paths.length; ++i) {
                try {
                    context = context.createSubcontext(paths[i]);
                    if (context != null) continue;
                    DataSourceRegistrar.handleException("sub context " + paths[i] + " could not be created");
                    continue;
                }
                catch (NamingException e) {
                    DataSourceRegistrar.handleException("Unable to create sub context : " + paths[i], e);
                }
            }
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static String getProperty(Properties dsProperties, String name, String def) {
        String result = dsProperties.getProperty(name);
        if ((result == null || result.length() == 0 || "".equals(result)) && def != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The name with ' " + name + " ' cannot be found. " + "Using default value " + def));
            }
            result = def;
        }
        if (result != null) {
            return result.trim();
        }
        return def;
    }
}

