/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics;

import org.apache.synapse.statistics.Statistics;

public class StatisticsHolder {
    private int statisticsCategory;
    private String key;
    private Statistics inFlowStatistics;
    private Statistics outFlowStatistics;

    public synchronized void update(boolean isResponse, long inTime, long outTime, boolean isFault) {
        if (isResponse) {
            if (this.outFlowStatistics == null) {
                this.outFlowStatistics = new Statistics();
            }
            this.outFlowStatistics.update(inTime, outTime, isFault);
        } else {
            if (this.inFlowStatistics == null) {
                this.inFlowStatistics = new Statistics();
            }
            this.inFlowStatistics.update(inTime, outTime, isFault);
        }
    }

    public synchronized Statistics getInFlowStatistics() {
        return this.inFlowStatistics;
    }

    public synchronized Statistics getOutFlowStatistics() {
        return this.outFlowStatistics;
    }

    public int getStatisticsCategory() {
        return this.statisticsCategory;
    }

    public void setStatisticsCategory(int statisticsCategory) {
        this.statisticsCategory = statisticsCategory;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public synchronized void clearStatistics() {
        this.inFlowStatistics = null;
        this.outFlowStatistics = null;
    }
}

