/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.tasks;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.Task;
import org.apache.synapse.util.PayloadHelper;

public class MessageInjector
implements Task,
ManagedLifecycle {
    private Log log = LogFactory.getLog(MessageInjector.class);
    private OMElement message = null;
    private String to = null;
    private String soapAction = null;
    private SynapseEnvironment synapseEnvironment;

    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
    }

    public void setMessage(OMElement elem) {
        this.log.debug((Object)("set message " + elem.toString()));
        this.message = elem;
    }

    public void setTo(String url) {
        this.to = url;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void execute() {
        this.log.debug((Object)"execute");
        if (this.synapseEnvironment == null) {
            this.log.error((Object)"Synapse Environment not set");
            return;
        }
        if (this.message == null) {
            this.log.error((Object)"message not set");
            return;
        }
        if (this.to == null) {
            this.log.error((Object)"to address not set");
            return;
        }
        MessageContext mc = this.synapseEnvironment.createMessageContext();
        mc.setTo(new EndpointReference(this.to));
        PayloadHelper.setXMLPayload(mc, this.message.cloneOMElement());
        if (this.soapAction != null) {
            mc.setSoapAction(this.soapAction);
        }
        this.synapseEnvironment.injectMessage(mc);
    }

    public void destroy() {
    }
}

