/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.StartupSerializer;
import org.apache.synapse.startup.quartz.SimpleQuartz;

public class SimpleQuartzSerializer
implements StartupSerializer {
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");
    protected static final QName PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property", "syn");

    public OMElement serializeStartup(OMElement parent, Startup s) {
        if (!(s instanceof SimpleQuartz)) {
            throw new SynapseException("called TaskSerializer on some other kind of startup" + s.getClass().getName());
        }
        SimpleQuartz sq = (SimpleQuartz)s;
        OMElement task = fac.createOMElement("task", synNS, (OMContainer)parent);
        task.addAttribute("name", sq.getName(), nullNS);
        task.addAttribute("class", sq.getJobClass(), nullNS);
        List pinnedServers = sq.getPinnedServers();
        if (pinnedServers != null && !pinnedServers.isEmpty()) {
            String pinnedServersStr = "" + pinnedServers.get(0);
            for (int i = 1; i < pinnedServers.size(); ++i) {
                pinnedServersStr = pinnedServersStr + " " + pinnedServers.get(i);
            }
            task.addAttribute(fac.createOMAttribute("pinnedServers", nullNS, pinnedServersStr));
        }
        OMElement el = fac.createOMElement("trigger", synNS, (OMContainer)task);
        if (sq.getInterval() == 1L && sq.getCount() == 1) {
            el.addAttribute("once", "true", nullNS);
        } else if (sq.getCron() != null) {
            el.addAttribute("cron", sq.getCron(), nullNS);
        } else {
            if (sq.getCount() != -1) {
                el.addAttribute("count", Integer.toString(sq.getCount()), nullNS);
            }
            if (sq.getInterval() != 0L) {
                long interval = sq.getInterval() / 1000L;
                el.addAttribute("interval", Long.toString(interval), nullNS);
            }
        }
        for (Object o : sq.getProperties()) {
            OMElement prop = (OMElement)o;
            task.addChild((OMNode)prop.cloneOMElement());
        }
        return task;
    }
}

