/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.config.xml.PropertyHelper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.Task;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SimpleQuartzJob
implements Job {
    public static final String SYNAPSE_ENVIRONMENT = "SynapseEnvironment";
    public static final String CLASSNAME = "ClassName";
    public static final String PROPERTIES = "Properties";
    private static final Log log = LogFactory.getLog(SimpleQuartzJob.class);

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        log.debug((Object)("Executing task : " + ctx.getJobDetail().getFullName()));
        JobDataMap jdm = ctx.getMergedJobDataMap();
        String jobClassName = (String)jdm.get((Object)CLASSNAME);
        if (jobClassName == null) {
            this.handleException("No ClassName in JobDetails");
        }
        Task task = null;
        try {
            task = (Task)this.getClass().getClassLoader().loadClass(jobClassName).newInstance();
        }
        catch (Exception e) {
            this.handleException("Cannot instantiate task : " + jobClassName, e);
        }
        Set properties = (Set)jdm.get((Object)PROPERTIES);
        for (OMElement prop : properties) {
            log.debug((Object)("Found Property : " + prop.toString()));
            PropertyHelper.setStaticProperty(prop, task);
        }
        SynapseEnvironment se = (SynapseEnvironment)jdm.get((Object)SYNAPSE_ENVIRONMENT);
        if (task instanceof ManagedLifecycle && se != null) {
            ((ManagedLifecycle)((Object)task)).init(se);
        }
        if (se.isInitialized()) {
            task.execute();
        }
    }

    private void handleException(String msg) throws JobExecutionException {
        log.error((Object)msg);
        throw new JobExecutionException(msg);
    }

    private void handleException(String msg, Exception e) throws JobExecutionException {
        log.error((Object)msg, (Throwable)e);
        throw new JobExecutionException(msg, (Throwable)e);
    }
}

