/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.AbstractStartup;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.startup.quartz.SimpleQuartzJob;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.DirectSchedulerFactory;

public class SimpleQuartz
extends AbstractStartup {
    private static final Log log = LogFactory.getLog(SimpleQuartz.class);
    private static final int THREADPOOLSIZE = 5;
    private String cron;
    private int repeatCount = -1;
    private long repeatInterval;
    private String className;
    private List pinnedServers;
    private Scheduler sch;
    Set xmlProperties = new HashSet();

    public QName getTagQName() {
        return SimpleQuartzFactory.TASK;
    }

    public void destroy() {
        if (this.sch != null) {
            try {
                this.sch.shutdown();
            }
            catch (SchedulerException e) {
                log.warn((Object)"Error shutting down scheduler", (Throwable)e);
                throw new SynapseException("Error shutting down scheduler", e);
            }
        }
    }

    public void init(SynapseEnvironment synapseEnvironment) {
        String thisServerName = ServerManager.getInstance().getServerName();
        if (thisServerName == null || thisServerName.equals("")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                thisServerName = addr.getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Could not get local host name", (Throwable)e);
            }
            if (thisServerName == null || thisServerName.equals("")) {
                thisServerName = "localhost";
            }
        }
        log.debug((Object)("Synapse server name : " + thisServerName));
        List pinnedServers = this.getPinnedServers();
        if (pinnedServers != null && !pinnedServers.isEmpty() && !pinnedServers.contains(thisServerName)) {
            log.info((Object)("Server name not in pinned servers list. Not starting Task : " + this.getName()));
            return;
        }
        try {
            this.sch = DirectSchedulerFactory.getInstance().getScheduler();
            if (this.sch == null) {
                DirectSchedulerFactory.getInstance().createVolatileScheduler(5);
                this.sch = DirectSchedulerFactory.getInstance().getScheduler();
            }
            if (this.sch == null) {
                throw new NullPointerException("Scheduler is null");
            }
            Trigger trigger = null;
            if (this.cron == null) {
                trigger = this.repeatCount >= 0 ? TriggerUtils.makeImmediateTrigger((int)(this.repeatCount - 1), (long)this.repeatInterval) : TriggerUtils.makeImmediateTrigger((int)-1, (long)this.repeatInterval);
            } else {
                CronTrigger cronTrig = new CronTrigger();
                cronTrig.setCronExpression(this.cron);
                trigger = cronTrig;
            }
            trigger.setName("Trigger" + String.valueOf(new Random().nextLong()));
            trigger.setGroup("synapse.simple.quartz");
            trigger.setVolatility(true);
            JobDetail jobDetail = new JobDetail();
            jobDetail.setName(this.name);
            jobDetail.setGroup("synapse.simple.quartz");
            jobDetail.setJobClass(SimpleQuartzJob.class);
            JobDataMap jdm = new JobDataMap();
            jdm.put((Object)"SynapseEnvironment", (Object)synapseEnvironment);
            jdm.put("ClassName", this.className);
            jdm.put((Object)"Properties", (Object)this.xmlProperties);
            jobDetail.setJobDataMap(jdm);
            this.sch.scheduleJob(jobDetail, trigger);
            this.sch.start();
            log.info((Object)("Scheduled job " + jobDetail.getFullName() + " for class " + this.className));
        }
        catch (Exception e) {
            log.fatal((Object)"Error starting up Scheduler", (Throwable)e);
            throw new SynapseException("Error starting up Scheduler", e);
        }
    }

    public String getJobClass() {
        return this.className;
    }

    public void setJobClass(String attributeValue) {
        this.className = attributeValue;
    }

    public void setInterval(long l) {
        this.repeatInterval = l;
    }

    public long getInterval() {
        return this.repeatInterval;
    }

    public void setCount(int i) {
        this.repeatCount = i;
    }

    public int getCount() {
        return this.repeatCount;
    }

    public void addProperty(OMElement prop) {
        this.xmlProperties.add(prop);
    }

    public Set getProperties() {
        return this.xmlProperties;
    }

    public void setCron(String attributeValue) {
        this.cron = attributeValue;
    }

    public String getCron() {
        return this.cron;
    }

    public List getPinnedServers() {
        return this.pinnedServers;
    }

    public void setPinnedServers(List pinnedServers) {
        this.pinnedServers = pinnedServers;
    }

    static {
        try {
            DirectSchedulerFactory.getInstance().createVolatileScheduler(5);
        }
        catch (SchedulerException e) {
            throw new SynapseException("Error initializing scheduler factory", e);
        }
    }
}

