/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.registry.url;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.registry.RegistryEntryImpl;

public class SimpleURLRegistry
extends AbstractRegistry
implements Registry {
    private static final Log log = LogFactory.getLog(SimpleURLRegistry.class);
    private static final int MAX_KEYS = 200;
    private String root = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMNode lookup(String key) {
        BufferedInputStream inputStream;
        log.debug((Object)("==> Repository fetch of resource with key : " + key));
        URL url = SynapseConfigUtils.getURLFromPath(this.root + key);
        if (url == null) {
            return null;
        }
        try {
            URLConnection connection = url.openConnection();
            connection.connect();
            inputStream = new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException e) {
            return null;
        }
        OMElement result = null;
        if (inputStream != null) {
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                result = builder.getDocumentElement();
            }
            catch (OMException ignored) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream. ", (Throwable)e);
                }
                result = SynapseConfigUtils.readNonXML(url);
            }
            catch (XMLStreamException ignored) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream. ", (Throwable)e);
                }
                result = SynapseConfigUtils.readNonXML(url);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream.", (Throwable)e);
                }
            }
        }
        return result;
    }

    public RegistryEntry getRegistryEntry(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Perform RegistryEntry lookup for key : " + key));
        }
        try {
            URL url = SynapseConfigUtils.getURLFromPath(this.root + key);
            if (url == null) {
                return null;
            }
            URLConnection urlc = url.openConnection();
            urlc.setReadTimeout(30000);
            urlc.setRequestProperty("Connection", "Close");
            RegistryEntryImpl wre = new RegistryEntryImpl();
            wre.setKey(key);
            wre.setName(url.getFile());
            wre.setType(new URI(urlc.getContentType()));
            wre.setDescription("Resource at : " + url.toString());
            wre.setLastModified(urlc.getLastModified());
            wre.setVersion(urlc.getLastModified());
            if (urlc.getExpiration() > 0L) {
                wre.setCachableDuration(urlc.getExpiration() - System.currentTimeMillis());
            } else {
                wre.setCachableDuration(this.getCachableDuration(key));
            }
            return wre;
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid URL reference " + this.root + key, e);
        }
        catch (IOException e) {
            this.handleException("IO Error reading from URL " + this.root + key, e);
        }
        catch (URISyntaxException e) {
            this.handleException("URI Syntax error reading from URL " + this.root + key, e);
        }
        return null;
    }

    public void init(Properties properties) {
        super.init(properties);
        String value = properties.getProperty("root");
        if (value != null) {
            try {
                URL url = new URL(value);
                if (url.getProtocol().equals("file") && !value.endsWith("/")) {
                    value = value + "/";
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.root = value;
        } else {
            this.handleException("");
        }
    }

    public void delete(String path) {
    }

    public void newResource(String path, boolean isDirectory) {
    }

    public void updateResource(String path, Object value) {
    }

    public void updateRegistryEntry(RegistryEntry entry) {
    }

    public long getCachableDuration(String rootPath) {
        String cachableDuration = (String)this.properties.get("cachableDuration");
        return cachableDuration == null ? 1500L : Long.parseLong(cachableDuration);
    }

    public RegistryEntry[] getChildren(RegistryEntry entry) {
        URL url;
        if (entry == null) {
            RegistryEntryImpl entryImpl = new RegistryEntryImpl();
            entryImpl.setKey("");
            entry = entryImpl;
        }
        if ((url = SynapseConfigUtils.getURLFromPath(this.root + entry.getKey())) == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return null;
            }
            InputStream inStream = null;
            try {
                inStream = (InputStream)url.getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                ArrayList<RegistryEntryImpl> entryList = new ArrayList<RegistryEntryImpl>();
                String key = "";
                while ((key = reader.readLine()) != null) {
                    RegistryEntryImpl registryEntryImpl = new RegistryEntryImpl();
                    if (entry.getKey().equals("")) {
                        registryEntryImpl.setKey(key);
                    } else if (entry.getKey().endsWith("/")) {
                        registryEntryImpl.setKey(entry.getKey() + key);
                    } else {
                        registryEntryImpl.setKey(entry.getKey() + "/" + key);
                    }
                    entryList.add(registryEntryImpl);
                }
                RegistryEntry[] entries = new RegistryEntry[entryList.size()];
                for (int i = 0; i < entryList.size(); ++i) {
                    entries[i] = (RegistryEntry)entryList.get(i);
                }
                return entries;
            }
            catch (Exception e) {
                throw new SynapseException("Error in reading the URL.");
            }
        }
        throw new SynapseException("Invalid protocol.");
    }

    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList list = new ArrayList();
        RegistryEntry[] entries = this.getChildren(entry);
        if (entries != null) {
            for (int i = 0; i < entries.length && list.size() <= 200; ++i) {
                this.fillDescendants(entries[i], list);
            }
        }
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = (RegistryEntry)list.get(i);
        }
        return descendants;
    }

    private void fillDescendants(RegistryEntry parent, ArrayList list) {
        RegistryEntry[] entries = this.getChildren(parent);
        if (entries != null) {
            for (int i = 0; i < entries.length && list.size() <= 200; ++i) {
                this.fillDescendants(entries[i], list);
            }
        } else {
            list.add(parent);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

