/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.ListMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class FilterMediator
extends AbstractListMediator
implements org.apache.synapse.mediators.FilterMediator {
    private SynapseXPath source = null;
    private Pattern regex = null;
    private SynapseXPath xpath = null;
    private ListMediator elseMediator = null;
    private boolean thenElementPresent = false;
    private String thenKey = null;
    private String elseKey = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Filter mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        boolean result = false;
        if (this.test(synCtx)) {
            if (this.thenKey != null) {
                Mediator seq;
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " matches" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to true") + " - executing then sequence with key : " + this.thenKey);
                }
                if ((seq = synCtx.getSequence(this.thenKey)) != null) {
                    result = seq.mediate(synCtx);
                } else {
                    this.handleException("Couldn't find the referred then sequence with key : " + this.thenKey, synCtx);
                }
            } else {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " matches" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to true") + " - executing child mediators");
                }
                result = super.mediate(synCtx);
            }
        } else if (this.elseKey != null) {
            Mediator elseSeq;
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false") + " - executing the else sequence with key : " + this.elseKey);
            }
            if ((elseSeq = synCtx.getSequence(this.elseKey)) != null) {
                result = elseSeq.mediate(synCtx);
            } else {
                this.handleException("Couldn't find the referred else sequence with key : " + this.elseKey, synCtx);
            }
        } else if (this.elseMediator != null) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false") + " - executing the else path child mediators");
            }
            result = this.elseMediator.mediate(synCtx);
        } else {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false and no else path") + " - skipping child mediators");
            }
            result = true;
        }
        if (traceOrDebugOn) {
            trace.trace((Object)"End : Filter mediator ");
        }
        return result;
    }

    public boolean test(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (this.xpath != null) {
            try {
                return this.xpath.booleanValueOf(synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + (Object)((Object)this.xpath), (Exception)((Object)e), synCtx);
            }
        } else if (this.source != null && this.regex != null) {
            String sourceString = this.source.stringValueOf(synCtx);
            if (sourceString == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Source String : " + (Object)((Object)this.source) + " evaluates to null");
                }
                return false;
            }
            Matcher matcher = this.regex.matcher(sourceString);
            if (matcher == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Regex pattren matcher for : " + this.regex.pattern() + "against source : " + sourceString + " is null");
                }
                return false;
            }
            return matcher.matches();
        }
        return false;
    }

    public SynapseXPath getSource() {
        return this.source;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public ListMediator getElseMediator() {
        return this.elseMediator;
    }

    public void setElseMediator(ListMediator elseMediator) {
        this.elseMediator = elseMediator;
    }

    public boolean isThenElementPresent() {
        return this.thenElementPresent;
    }

    public void setThenElementPresent(boolean thenElementPresent) {
        this.thenElementPresent = thenElementPresent;
    }

    public String getThenKey() {
        return this.thenKey;
    }

    public void setThenKey(String thenKey) {
        this.thenKey = thenKey;
    }

    public String getElseKey() {
        return this.elseKey;
    }

    public void setElseKey(String elseKey) {
        this.elseKey = elseKey;
    }
}

