/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Command;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOCommandMediator
extends AbstractMediator {
    private Class command = null;
    private Map<String, Object> staticSetterProperties = new HashMap<String, Object>();
    private Map<String, SynapseXPath> messageSetterProperties = new HashMap<String, SynapseXPath>();
    private Map<String, String> contextSetterProperties = new HashMap<String, String>();
    private Map<String, String> contextGetterProperties = new HashMap<String, String>();
    private Map<String, SynapseXPath> messageGetterProperties = new HashMap<String, SynapseXPath>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseXPath xpath;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : POJOCommand mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Creating a new instance of POJO class : " + this.command.getClass());
        }
        Object commandObject = null;
        try {
            commandObject = this.command.newInstance();
        }
        catch (Exception e) {
            this.handleException("Error creating an instance of the POJO command class : " + this.command.getClass(), e, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Instance created, setting static and dynamic properties");
        }
        for (String name : this.staticSetterProperties.keySet()) {
            this.setInstanceProperty(name, this.staticSetterProperties.get(name), commandObject, synCtx);
        }
        for (String name : this.contextSetterProperties.keySet()) {
            this.setInstanceProperty(name, synCtx.getProperty(this.contextSetterProperties.get(name)), commandObject, synCtx);
        }
        for (String name : this.messageSetterProperties.keySet()) {
            xpath = this.messageSetterProperties.get(name);
            String value = xpath.stringValueOf(synCtx);
            this.setInstanceProperty(name, value, commandObject, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "POJO initialized successfully, invoking the execute() method");
        }
        if (commandObject instanceof Command) {
            try {
                ((Command)commandObject).execute();
            }
            catch (Exception e) {
                this.handleException("Error invoking POJO command class : " + this.command.getClass(), e, synCtx);
            }
        } else {
            Method exeMethod = null;
            try {
                exeMethod = this.command.getMethod("execute", new Class[0]);
                exeMethod.invoke(commandObject, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.handleException("Cannot locate an execute() method on POJO class : " + this.command.getClass(), e, synCtx);
            }
            catch (Exception e) {
                this.handleException("Error invoking the execute() method on POJO class : " + this.command.getClass(), e, synCtx);
            }
        }
        for (String name : this.contextGetterProperties.keySet()) {
            synCtx.setProperty(this.contextGetterProperties.get(name), this.getInstanceProperty(name, commandObject, synCtx));
        }
        for (String name : this.messageGetterProperties.keySet()) {
            xpath = this.messageGetterProperties.get(name);
            Object resultValue = this.getInstanceProperty(name, commandObject, synCtx);
            try {
                List list = EIPUtils.getMatchingElements(synCtx.getEnvelope(), xpath);
                if (list.size() > 0) {
                    Object o = list.get(0);
                    if (resultValue instanceof String) {
                        OMAbstractFactory.getOMFactory().createOMText(((OMNode)o).getParent(), (String)resultValue);
                        ((OMNode)o).detach();
                        continue;
                    }
                    if (!(resultValue instanceof OMNode)) continue;
                    ((OMNode)o).insertSiblingAfter((OMNode)resultValue);
                    ((OMNode)o).detach();
                    continue;
                }
                if (!traceOrDebugOn) continue;
                this.traceOrDebug(traceOn, "Unable to set the message property " + resultValue + "back to the message : Specified element by the xpath " + (Object)((Object)xpath) + " can not be found");
            }
            catch (JaxenException e) {
                this.handleException("Unable to set the command property " + name + " back to the message", (Exception)((Object)e), synCtx);
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : POJOCommand mediator");
        }
        return true;
    }

    private Object getInstanceProperty(String name, Object obj, MessageContext synCtx) {
        String mName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                if (!mName.equals(method.getName())) continue;
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            this.handleException("Unable to get the command property '" + name + "' back to the message", e, synCtx);
        }
        catch (IllegalAccessException e) {
            this.handleException("Unable to get the command property '" + name + "' back to the message", e, synCtx);
        }
        return null;
    }

    protected void setInstanceProperty(String name, Object value, Object obj, MessageContext synCtx) {
        String mName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        Method method = null;
        try {
            Method[] methods = obj.getClass().getMethods();
            boolean invoked = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!mName.equals(methods[i].getName())) continue;
                Class<?>[] params = methods[i].getParameterTypes();
                if (params.length != 1) {
                    this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean or OMElement parameter", synCtx);
                } else if (value instanceof String) {
                    if (params[0].equals(String.class)) {
                        method = obj.getClass().getMethod(mName, String.class);
                        method.invoke(obj, (Object[])new String[]{(String)value});
                    } else if (params[0].equals(Integer.TYPE)) {
                        method = obj.getClass().getMethod(mName, Integer.TYPE);
                        method.invoke(obj, (Object[])new Integer[]{new Integer((String)value)});
                    } else if (params[0].equals(Long.TYPE)) {
                        method = obj.getClass().getMethod(mName, Long.TYPE);
                        method.invoke(obj, (Object[])new Long[]{new Long((String)value)});
                    } else if (params[0].equals(Float.TYPE)) {
                        method = obj.getClass().getMethod(mName, Float.TYPE);
                        method.invoke(obj, (Object[])new Float[]{new Float((String)value)});
                    } else if (params[0].equals(Double.TYPE)) {
                        method = obj.getClass().getMethod(mName, Double.TYPE);
                        method.invoke(obj, (Object[])new Double[]{new Double((String)value)});
                    } else if (params[0].equals(Boolean.TYPE)) {
                        method = obj.getClass().getMethod(mName, Boolean.TYPE);
                        method.invoke(obj, (Object[])new Boolean[]{new Boolean((String)value)});
                    } else {
                        this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", synCtx);
                    }
                } else if (value instanceof OMElement) {
                    if (params[0].equals(OMElement.class)) {
                        method = obj.getClass().getMethod(mName, OMElement.class);
                        method.invoke(obj, (Object[])new OMElement[]{(OMElement)value});
                    } else {
                        this.handleException("Did not find a setter method named : " + mName + "() that takes an OMElement as the parameter", synCtx);
                    }
                } else {
                    this.handleException("Can not handle the value type : " + value.getClass(), synCtx);
                }
                invoked = true;
            }
            if (!invoked) {
                this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", synCtx);
            }
        }
        catch (Exception e) {
            this.handleException("Error invoking setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", e, synCtx);
        }
    }

    public Class getCommand() {
        return this.command;
    }

    public void setCommand(Class command) {
        this.command = command;
    }

    public void addStaticSetterProperty(String name, Object value) {
        this.staticSetterProperties.put(name, value);
    }

    public void addMessageSetterProperty(String name, SynapseXPath xpath) {
        this.messageSetterProperties.put(name, xpath);
    }

    public void addContextSetterProperty(String name, String ctxName) {
        this.contextSetterProperties.put(name, ctxName);
    }

    public void addContextGetterProperty(String name, String value) {
        this.contextGetterProperties.put(name, value);
    }

    public void addMessageGetterProperty(String name, SynapseXPath xpath) {
        this.messageGetterProperties.put(name, xpath);
    }

    public Map<String, Object> getStaticSetterProperties() {
        return this.staticSetterProperties;
    }

    public Map<String, SynapseXPath> getMessageSetterProperties() {
        return this.messageSetterProperties;
    }

    public Map<String, String> getContextSetterProperties() {
        return this.contextSetterProperties;
    }

    public Map<String, String> getContextGetterProperties() {
        return this.contextGetterProperties;
    }

    public Map<String, SynapseXPath> getMessageGetterProperties() {
        return this.messageGetterProperties;
    }
}

