/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.List;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.mediators.AbstractMediator;

public class SendMediator
extends AbstractMediator {
    private Endpoint endpoint = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Send mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (synCtx.isResponse()) {
            Axis2MessageContext axis2MsgCtx = (Axis2MessageContext)synCtx;
            OperationContext opCtx = axis2MsgCtx.getAxis2MessageContext().getOperationContext();
            boolean isClusteringEnable = false;
            org.apache.axis2.context.MessageContext axisMC = axis2MsgCtx.getAxis2MessageContext();
            ConfigurationContext cc = axisMC.getConfigurationContext();
            ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
            if (clusterManager != null && clusterManager.getContextManager() != null) {
                isClusteringEnable = true;
            }
            if (isClusteringEnable) {
                Object epNames = opCtx.getPropertyNonReplicable("endpointNameList");
                if (epNames != null && epNames instanceof List) {
                    Endpoint rootEP;
                    String name;
                    Object rootEPObj;
                    List epNameList = (List)epNames;
                    Object obj = epNameList.remove(0);
                    if (obj != null && obj instanceof String && (rootEPObj = opCtx.getPropertyNonReplicable("rootendpoint")) != null && rootEPObj instanceof Endpoint && (name = ((Endpoint)rootEPObj).getName()) != null && name.equals(obj) && (rootEP = (Endpoint)rootEPObj) instanceof SALoadbalanceEndpoint) {
                        SALoadbalanceEndpoint salEP = (SALoadbalanceEndpoint)rootEP;
                        salEP.updateSession(synCtx, epNameList, isClusteringEnable);
                    }
                    opCtx.setProperty("endpointNameList", epNames);
                }
            } else {
                List epList;
                Object e;
                Object o = opCtx.getProperty("endpointList");
                if (o != null && o instanceof List && (e = (epList = (List)o).remove(0)) != null && e instanceof SALoadbalanceEndpoint) {
                    SALoadbalanceEndpoint salEP = (SALoadbalanceEndpoint)e;
                    salEP.updateSession(synCtx, epList, isClusteringEnable);
                }
            }
        }
        if (this.endpoint == null) {
            if (traceOrDebugOn) {
                StringBuffer sb = new StringBuffer();
                sb.append("Sending " + (synCtx.isResponse() ? "response" : "request") + " message using implicit message properties..");
                sb.append("\nSending To: " + (synCtx.getTo() != null ? synCtx.getTo().getAddress() : "null"));
                sb.append("\nSOAPAction: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
                this.traceOrDebug(traceOn, sb.toString());
            }
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Envelope : " + synCtx.getEnvelope()));
            }
            synCtx.getEnvironment().send(null, synCtx);
        } else {
            this.endpoint.send(synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Send mediator");
        }
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }
}

