/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.UUIDGenerator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class RMSequenceMediator
extends AbstractMediator {
    private SynapseXPath correlation = null;
    private SynapseXPath lastMessage = null;
    private Boolean single = null;
    private String version = null;
    private static final String WSRM_SpecVersion_1_0 = "Spec_2005_02";
    private static final String WSRM_SpecVersion_1_1 = "Spec_2007_02";
    private static final long SEQUENCE_EXPIRY_TIME = 300000L;
    private static Map sequenceMap = Collections.synchronizedMap(new HashMap());

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : RMSequence mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (!(synCtx instanceof Axis2MessageContext)) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Only axis2 message contexts are supported");
            }
        } else {
            Axis2MessageContext axis2MessageCtx = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext orgMessageCtx = axis2MessageCtx.getAxis2MessageContext();
            this.cleanupSequenceMap();
            String version = this.getVersionValue();
            orgMessageCtx.getOptions().setProperty("MercuryRMSpecVersion", (Object)version);
            if (this.isSingle()) {
                String sequenceID = UUIDGenerator.getUUID();
                String offeredSeqID = UUIDGenerator.getUUID();
                orgMessageCtx.getOptions().setProperty("MercurySequenceKey", (Object)sequenceID);
                orgMessageCtx.getOptions().setProperty("MercurySequenceOffer", (Object)offeredSeqID);
                orgMessageCtx.getOptions().setProperty("MercuryLastMessage", (Object)"true");
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Using WS-RM version " + version + " and a single message sequence : " + sequenceID + " and offering sequence : " + offeredSeqID);
                }
            } else {
                String correlationValue = this.getCorrelationValue(synCtx);
                boolean lastMessage = this.isLastMessage(synCtx);
                String offeredSeqID = null;
                if (!sequenceMap.containsKey(correlationValue)) {
                    offeredSeqID = UUIDGenerator.getUUID();
                    orgMessageCtx.getOptions().setProperty("MercurySequenceOffer", (Object)offeredSeqID);
                }
                String sequenceID = this.retrieveSequenceID(correlationValue);
                orgMessageCtx.getOptions().setProperty("MercurySequenceKey", (Object)sequenceID);
                if (lastMessage) {
                    orgMessageCtx.getOptions().setProperty("MercuryLastMessage", (Object)"true");
                    sequenceMap.remove(correlationValue);
                }
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Correlation value : " + correlationValue + " last message = " + lastMessage + " using sequence : " + sequenceID + (offeredSeqID != null ? " offering sequence : " + offeredSeqID : ""));
                }
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : RMSequence mediator");
        }
        return true;
    }

    private String retrieveSequenceID(String correlationValue) {
        String sequenceID = null;
        if (!sequenceMap.containsKey(correlationValue)) {
            sequenceID = UUIDGenerator.getUUID();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setting sequenceID " + sequenceID + " for correlation " + correlationValue));
            }
            Entry sequenceEntry = new Entry();
            sequenceEntry.setValue(sequenceID);
            sequenceEntry.setExpiryTime(System.currentTimeMillis() + 300000L);
            sequenceMap.put(correlationValue, sequenceEntry);
        } else {
            sequenceID = (String)((Entry)sequenceMap.get(correlationValue)).getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("got sequenceID " + sequenceID + " for correlation " + correlationValue));
            }
        }
        return sequenceID;
    }

    private String getCorrelationValue(MessageContext smc) {
        OMElement node = null;
        try {
            node = (OMElement)this.getCorrelation().selectSingleNode(smc);
            if (node != null) {
                return node.getText();
            }
            this.handleException("XPath expression : " + (Object)((Object)this.getCorrelation()) + " did not return any node", smc);
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression to determine correlation : " + (Object)((Object)this.getCorrelation()), (Exception)((Object)e), smc);
        }
        return null;
    }

    private String getVersionValue() {
        if ("1.1".equals(this.getVersion())) {
            return WSRM_SpecVersion_1_1;
        }
        return WSRM_SpecVersion_1_0;
    }

    private boolean isLastMessage(MessageContext smc) {
        if (this.getLastMessage() == null) {
            return false;
        }
        try {
            return this.getLastMessage().booleanValueOf(smc);
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression to determine if last message : " + (Object)((Object)this.getLastMessage()), (Exception)((Object)e), smc);
            return false;
        }
    }

    private synchronized void cleanupSequenceMap() {
        for (Object key : sequenceMap.keySet()) {
            Entry sequenceEntry = (Entry)sequenceMap.get(key);
            if (!sequenceEntry.isExpired()) continue;
            sequenceMap.remove(key);
        }
    }

    public boolean isSingle() {
        return this.getSingle() != null && this.getSingle() != false;
    }

    public SynapseXPath getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(SynapseXPath correlation) {
        this.correlation = correlation;
    }

    public SynapseXPath getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(SynapseXPath lastMessage) {
        this.lastMessage = lastMessage;
    }

    public Boolean getSingle() {
        return this.single;
    }

    public void setSingle(Boolean single) {
        this.single = single;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

