/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class PropertyMediator
extends AbstractMediator {
    private String name = null;
    private String value = null;
    private SynapseXPath expression = null;
    private String scope = null;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private int action = 0;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Property mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (this.action == 0) {
            String resultValue;
            String string = resultValue = this.value != null ? this.value : this.expression.stringValueOf(synCtx);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Setting property : " + this.name + " at scope : " + (this.scope == null ? "default" : this.scope) + " to : " + resultValue + " (i.e. " + (this.value != null ? "constant : " + this.value : "result of expression : " + (Object)((Object)this.expression)) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                synCtx.setProperty(this.name, resultValue);
            } else if ("axis2".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.setProperty(this.name, (Object)resultValue);
            } else if ("axis2-client".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getOptions().setProperty(this.name, (Object)resultValue);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                HashMap<String, String> headersMap;
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    headersMap = (HashMap<String, String>)headers;
                    headersMap.put(this.name, resultValue);
                }
                if (headers == null) {
                    headersMap = new HashMap<String, String>();
                    headersMap.put(this.name, resultValue);
                    axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
                }
            }
        } else {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Removing property : " + this.name + " (scope:" + (this.scope == null ? "default" : this.scope) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                Set pros = synCtx.getPropertyKeySet();
                if (pros != null) {
                    pros.remove(this.name);
                }
            } else if (("axis2".equals(this.scope) || "axis2-client".equals(this.scope)) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.removeProperty(this.name);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    HashMap headersMap = (HashMap)headers;
                    headersMap.remove(this.name);
                } else if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "No transport headers found for the message");
                }
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Property mediator");
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }
}

