/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.DispatcherContext;

public class SoapSessionDispatcher
implements Dispatcher {
    private static final Log log = LogFactory.getLog(SoapSessionDispatcher.class);
    private static final QName QNAME_SERVICE_GROUP_ID = new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2");

    public Endpoint getEndpoint(MessageContext synCtx, DispatcherContext dispatcherContext) {
        Endpoint endpoint = null;
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null) {
            OMElement sgcElm = header.getFirstChildWithName(QNAME_SERVICE_GROUP_ID);
            if (sgcElm != null) {
                String sgcID = sgcElm.getText();
                if (sgcID != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using the ServiceGroupId SOAP header value " + sgcID + " to retrieve endpoint on the session"));
                    }
                    endpoint = dispatcherContext.getEndpoint(sgcID);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the ServiceQroupId SOAP header to retrieve the endpoint on the session");
            }
        }
        return endpoint;
    }

    public void updateSession(MessageContext synCtx, DispatcherContext dispatcherContext, Endpoint endpoint) {
        if (endpoint == null || dispatcherContext == null) {
            return;
        }
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null) {
            OMElement replyTo = header.getFirstChildWithName(AddressingConstants.Final.QNAME_WSA_REPLY_TO);
            if (replyTo != null) {
                OMElement referenceParameters = replyTo.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters", "wsa"));
                if (referenceParameters != null) {
                    OMElement sgcElm = referenceParameters.getFirstChildWithName(QNAME_SERVICE_GROUP_ID);
                    if (sgcElm != null) {
                        String sgcID = sgcElm.getText();
                        if (sgcID != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Using the ServiceGroupId value " + sgcID + " to update the endpoint session"));
                            }
                            dispatcherContext.setEndpoint(sgcID, endpoint);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Couldn't find the WSA ServiceQroupId on the ReferenceParameters of the Reply-To header to update the session");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Couldn't find the WSA ReferenceParameters in the Reply-To header to retrieve the ServiceQroupId");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the WSA Reply-To header to retrieve the ServiceQroupId");
            }
        }
    }

    public void unbind(MessageContext synCtx, DispatcherContext dispatcherContext) {
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null) {
            OMElement sgcIDElm = header.getFirstChildWithName(QNAME_SERVICE_GROUP_ID);
            if (sgcIDElm != null) {
                String sgcID = sgcIDElm.getText();
                if (sgcID != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using the ServiceGroupId value " + sgcID + " to unbind session"));
                    }
                    dispatcherContext.removeSession(sgcID);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the ServiceQroupId SOAP header to unbind the session");
            }
        }
    }

    public boolean isServerInitiatedSession() {
        return true;
    }
}

