/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.DispatcherContext;

public class HttpSessionDispatcher
implements Dispatcher {
    private static final Log log = LogFactory.getLog(HttpSessionDispatcher.class);
    private static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";

    public Endpoint getEndpoint(MessageContext synCtx, DispatcherContext dispatcherContext) {
        Endpoint endpoint = null;
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            Object cookie = headerMap.get(COOKIE);
            if (cookie != null && cookie instanceof String) {
                Endpoint ep;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the HTTP header 'Cookie: " + cookie + "' to retrieve the endpoint in the transport session"));
                }
                if ((ep = dispatcherContext.getEndpoint((String)cookie)) != null && ep instanceof Endpoint) {
                    endpoint = ep;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No endpoint found in the transport session for the session id " + cookie));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No 'Cookie' HTTP headers found to extract the endpoint from the transport session");
            }
        }
        return endpoint;
    }

    public void updateSession(MessageContext synCtx, DispatcherContext dispatcherContext, Endpoint endpoint) {
        if (endpoint == null || dispatcherContext == null) {
            return;
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            Object cookie = headerMap.get(SET_COOKIE);
            if (cookie != null && cookie instanceof String) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found the HTTP header 'Set-Cookie: " + cookie + "' for updating the session"));
                }
                String sessionId = ((String)cookie).split(";")[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the session id '" + sessionId + "' extracted from the Set-Cookie header to update the session " + "with the endpoint " + endpoint));
                }
                dispatcherContext.setEndpoint(sessionId, endpoint);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No 'Set-Cookie' HTTP header is specified in the message to update the session");
            }
        }
    }

    public void unbind(MessageContext synCtx, DispatcherContext dispatcherContext) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            Object cookie = headerMap.get(COOKIE);
            if (cookie != null && cookie instanceof String) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the HTTP header 'Cookie: " + cookie + "' to unbind the session"));
                }
                dispatcherContext.removeSession((String)cookie);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No 'Cookie' HTTP header is specified in the message to unbind the session");
            }
        }
    }

    public boolean isServerInitiatedSession() {
        return true;
    }
}

