/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherContext {
    private static final Log log = LogFactory.getLog(DispatcherContext.class);
    private static final String SESSION = "session";
    private static final String UNDERSCORE_STRING = "_";
    private final Map<String, Endpoint> sessionMap = Collections.synchronizedMap(new HashMap());
    private ConfigurationContext configCtx;
    private boolean isClusteringEnable = false;
    private String keyPrefix;
    private final Map<String, Endpoint> endpointsMap = new HashMap<String, Endpoint>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint(String sessionID) {
        if (this.isClusteringEnable) {
            Object value;
            if (this.keyPrefix == null || "".equals(this.keyPrefix)) {
                this.handleException("Cannot find the required key prefix to find the shared state of one of  'session'");
            }
            if ((value = this.configCtx.getPropertyNonReplicable(this.keyPrefix + sessionID)) != null && value instanceof String) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieving the endpoint from the session id " + value));
                }
                return this.endpointsMap.get(value.toString());
            }
        } else {
            Map<String, Endpoint> map = this.sessionMap;
            synchronized (map) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieving the endpoint from the session id " + sessionID));
                }
                return this.sessionMap.get(sessionID);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String sessionID, Endpoint endpoint) {
        if (this.isClusteringEnable) {
            String endpointName = endpoint instanceof IndirectEndpoint ? ((IndirectEndpoint)endpoint).getKey() : endpoint.getName();
            if (endpointName == null) {
                if (log.isDebugEnabled() && this.isClusteringEnable()) {
                    log.warn((Object)"In a clustering environment, the endpoint name should be specified even for anonymous endpoints. Otherwise the clustering would not function properly, if there are more than one anonymous endpoints.");
                }
                endpointName = "AnonymousEndpoint";
            }
            if (this.keyPrefix != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding the enpoint " + endpointName + " with the session id " + this.keyPrefix + sessionID + " for replication to the session"));
                }
                this.setAndReplicateState(this.keyPrefix + sessionID, endpointName);
            }
        } else {
            Map<String, Endpoint> map = this.sessionMap;
            synchronized (map) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding the endpoint " + endpoint + " with the session id " + sessionID + " to the session"));
                }
                this.sessionMap.put(sessionID, endpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String id) {
        if (this.isClusteringEnable) {
            if (this.keyPrefix != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing and replicating the session with the session id " + this.keyPrefix + id));
                }
                this.removeAndReplicateState(this.keyPrefix + id);
            }
        } else {
            Map<String, Endpoint> map = this.sessionMap;
            synchronized (map) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing the session with the session id " + id));
                }
                this.sessionMap.remove(id);
            }
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    public void setConfigurationContext(ConfigurationContext configCtx) {
        if (configCtx == null) {
            this.handleException("The ConfigurationContext cannot be null when system in a cluster environment");
        }
        this.configCtx = configCtx;
        this.isClusteringEnable = true;
    }

    public void setContextID(String contextID) {
        if (contextID == null || "".equals(contextID)) {
            this.handleException("The Context ID cannot be null when system in a cluster environment");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(contextID);
        buffer.append(UNDERSCORE_STRING);
        buffer.append(SESSION);
        buffer.append(UNDERSCORE_STRING);
        this.keyPrefix = buffer.toString();
    }

    protected void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void setAndReplicateState(String key, Object value) {
        if (this.configCtx != null && key != null && value != null) {
            try {
                Object prop;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property with key : " + key + " value : " + value));
                }
                if ((prop = this.configCtx.getPropertyNonReplicable(key)) == null) {
                    this.configCtx.setProperty(key, value);
                    Replicator.replicate((AbstractContext)this.configCtx, (String[])new String[]{key});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property with key: " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                this.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }

    private void removeAndReplicateState(String key) {
        if (this.configCtx != null && key != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property removal with key : " + key));
                }
                this.configCtx.removeProperty(key);
                Replicator.replicate((AbstractContext)this.configCtx, (String[])new String[]{key});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property removal with key : " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                this.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }

    public boolean isClusteringEnable() {
        return this.isClusteringEnable;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                String endpointName = endpoint instanceof IndirectEndpoint ? ((IndirectEndpoint)endpoint).getKey() : endpoint.getName();
                if (endpointName == null) {
                    if (log.isDebugEnabled() && this.isClusteringEnable()) {
                        log.warn((Object)"In a clustering environment, the endpoint name should be specified even for anonymous endpoints. Otherwise the clustering would not function properly, if there are more than one anonymous endpoints.");
                    }
                    endpointName = "AnonymousEndpoint";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding an endpoint with the name/key " + endpointName + " to the endpoints map"));
                }
                this.endpointsMap.put(endpointName, endpoint);
            }
        }
    }
}

