/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class RoundRobin
implements LoadbalanceAlgorithm {
    private static final Log log = LogFactory.getLog(RoundRobin.class);
    private ArrayList endpoints = null;

    public RoundRobin(ArrayList endpoints) {
        this.endpoints = endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getNextEndpoint(MessageContext synapseMessageContext, AlgorithmContext algorithmContext) {
        Endpoint nextEndpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using the Round Robin loadbalancing algorithm to select the next endpoint");
        }
        int attempts = 0;
        int currentEPR = algorithmContext.getCurrentEndpointIndex();
        do {
            RoundRobin roundRobin = this;
            synchronized (roundRobin) {
                nextEndpoint = (Endpoint)this.endpoints.get(currentEPR);
                currentEPR = currentEPR == this.endpoints.size() - 1 ? 0 : ++currentEPR;
                algorithmContext.setCurrentEPR(currentEPR);
            }
            if (++attempts <= this.endpoints.size()) continue;
            log.warn((Object)"Couldn't find an endpoint from the Round Robin loadbalancing algorithm");
            return null;
        } while (!nextEndpoint.isActive(synapseMessageContext));
        return nextEndpoint;
    }

    public void reset(AlgorithmContext algorithmContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resetting the Round Robin loadbalancing algorithm ...");
        }
        algorithmContext.setCurrentEPR(0);
    }
}

