/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class AlgorithmContext {
    private static final Log log = LogFactory.getLog(AlgorithmContext.class);
    private static final String UNDERSCORE_STRING = "_";
    private static final String CURRENT_EPR = "currentEPR";
    private ConfigurationContext configCtx;
    private boolean isClusteringEnable = false;
    private String currentEPRPropertyKey;
    private int currentEPR = 0;

    public int getCurrentEndpointIndex() {
        if (this.isClusteringEnable) {
            Object value;
            if (this.currentEPRPropertyKey == null || "".equals(this.currentEPRPropertyKey)) {
                this.handleException("Cannot find the required key to find the shared state of the 'currentEPR' attribute");
            }
            if ((value = this.configCtx.getPropertyNonReplicable(this.currentEPRPropertyKey)) == null) {
                return 0;
            }
            try {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
            }
            catch (NumberFormatException e) {
                this.handleException("The invalid value for the 'currentEPR' attribute");
            }
        } else {
            return this.currentEPR;
        }
        return 0;
    }

    public void setCurrentEPR(int currentEPR) {
        if (this.isClusteringEnable) {
            if (this.currentEPRPropertyKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting the current EPR " + currentEPR + " with the key " + this.currentEPRPropertyKey));
                }
                this.setAndReplicateState(this.currentEPRPropertyKey, currentEPR);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting the current EPR " + currentEPR));
            }
            this.currentEPR = currentEPR;
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    public void setConfigurationContext(ConfigurationContext configCtx) {
        if (configCtx == null) {
            this.handleException("The ConfigurationContext cannot be null when system in a cluster environment");
        }
        this.configCtx = configCtx;
        this.isClusteringEnable = true;
    }

    public void setContextID(String contextID) {
        if (contextID == null || "".equals(contextID)) {
            this.handleException("The Context ID cannot be null when system in a cluster environment");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(contextID);
        buffer.append(UNDERSCORE_STRING);
        buffer.append(CURRENT_EPR);
        this.currentEPRPropertyKey = buffer.toString();
    }

    protected void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void setAndReplicateState(String key, Object value) {
        if (this.configCtx != null && key != null && value != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property with key : " + key + " value : " + value));
                }
                this.configCtx.setProperty(key, value);
                Replicator.replicate((AbstractContext)this.configCtx, (String[])new String[]{key});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property with key : " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                this.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }
}

