/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.DispatcherContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SALoadbalanceEndpoint
implements Endpoint {
    private static final Log log = LogFactory.getLog(SALoadbalanceEndpoint.class);
    private static final String FIRST_MESSAGE_IN_SESSION = "first_message_in_session";
    public static final String ENDPOINT_LIST = "endpointList";
    public static final String ROOT_ENDPOINT = "rootendpoint";
    public static final String ENDPOINT_NAME_LIST = "endpointNameList";
    public static final String WARN_MESSAGE = "In a clustering environment, the endpoint name should be specified even for anonymous endpoints. Otherwise the clustering would not function properly, if there are more than one anonymous endpoints.";
    private String name = null;
    private List<Endpoint> endpoints = null;
    private LoadbalanceAlgorithm algorithm = null;
    private Endpoint parentEndpoint = null;
    private Dispatcher dispatcher = null;
    private final DispatcherContext dispatcherContext = new DispatcherContext();
    private final EndpointContext endpointContext = new EndpointContext();
    private final AlgorithmContext algorithmContext = new AlgorithmContext();

    @Override
    public void send(MessageContext synMessageContext) {
        Endpoint endpoint;
        String endpointName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start : Session Affinity Load-balance Endpoint " + this.name));
        }
        boolean isClusteringEnable = false;
        org.apache.axis2.context.MessageContext axisMC = ((Axis2MessageContext)synMessageContext).getAxis2MessageContext();
        ConfigurationContext cc = axisMC.getConfigurationContext();
        ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
        if (clusterManager != null && clusterManager.getContextManager() != null) {
            isClusteringEnable = true;
        }
        if ((endpointName = this.getName()) == null) {
            if (isClusteringEnable) {
                log.warn((Object)WARN_MESSAGE);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using the name for the anonymous endpoint as : 'AnonymousEndpoint'");
            }
            endpointName = "AnonymousEndpoint";
        }
        if (isClusteringEnable) {
            if (this.endpointContext.getConfigurationContext() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting the ConfigurationContext to the EndpointContext with the name " + endpointName + " for replicating data on the cluster"));
                }
                this.endpointContext.setConfigurationContext(cc);
                this.endpointContext.setContextID(endpointName);
            }
            if (this.algorithmContext.getConfigurationContext() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting the ConfigurationContext to the AlgorithmContext with the name " + endpointName + " for replicating data on the cluster"));
                }
                this.algorithmContext.setConfigurationContext(cc);
                this.algorithmContext.setContextID(endpointName);
            }
            if (this.dispatcherContext.getConfigurationContext() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting the ConfigurationContext to the DispatcherContext with the name " + endpointName + " for replicating data on the cluster"));
                }
                this.dispatcherContext.setConfigurationContext(cc);
                this.dispatcherContext.setContextID(endpointName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting the endpoints to the DispatcherContext : " + this.endpoints));
                }
                this.dispatcherContext.setEndpoints(this.endpoints);
            }
        }
        if ((endpoint = this.dispatcher.getEndpoint(synMessageContext, this.dispatcherContext)) == null) {
            endpoint = this.algorithm.getNextEndpoint(synMessageContext, this.algorithmContext);
            if (this.dispatcher.isServerInitiatedSession()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding a new server initiated session for the current message");
                }
                Axis2MessageContext axis2MsgCtx = (Axis2MessageContext)synMessageContext;
                OperationContext opCtx = axis2MsgCtx.getAxis2MessageContext().getOperationContext();
                if (isClusteringEnable) {
                    ArrayList<String> epNameList;
                    Object o = opCtx.getPropertyNonReplicable(ENDPOINT_NAME_LIST);
                    if (o instanceof List) {
                        epNameList = (ArrayList<String>)o;
                        epNameList.add(endpointName);
                    } else {
                        epNameList = new ArrayList<String>();
                        epNameList.add(endpointName);
                        opCtx.setNonReplicableProperty(ROOT_ENDPOINT, (Object)this);
                    }
                    if (!(endpoint instanceof SALoadbalanceEndpoint)) {
                        String name = endpoint instanceof IndirectEndpoint ? ((IndirectEndpoint)endpoint).getKey() : endpoint.getName();
                        if (name == null) {
                            log.warn((Object)WARN_MESSAGE);
                            name = "AnonymousEndpoint";
                        }
                        epNameList.add(name);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Operating on a cluster. Setting the endpoint name list to the OperationContext : " + epNameList));
                    }
                    opCtx.setProperty(ENDPOINT_NAME_LIST, epNameList);
                } else {
                    ArrayList<SALoadbalanceEndpoint> endpointList;
                    Object o = opCtx.getProperty(ENDPOINT_LIST);
                    if (o instanceof List) {
                        endpointList = (ArrayList<SALoadbalanceEndpoint>)o;
                        endpointList.add(this);
                    } else {
                        endpointList = new ArrayList<SALoadbalanceEndpoint>();
                        endpointList.add(this);
                        opCtx.setProperty(ENDPOINT_LIST, endpointList);
                    }
                    if (!(endpoint instanceof SALoadbalanceEndpoint)) {
                        endpointList.add((SALoadbalanceEndpoint)endpoint);
                    }
                }
            } else {
                this.dispatcher.updateSession(synMessageContext, this.dispatcherContext, endpoint);
            }
            synMessageContext.getEnvelope().build();
            synMessageContext.setProperty(FIRST_MESSAGE_IN_SESSION, Boolean.TRUE);
        }
        if (endpoint != null) {
            if (endpoint.isActive(synMessageContext)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the endpoint on the session with " + (endpoint instanceof IndirectEndpoint ? "key : " + ((IndirectEndpoint)endpoint).getKey() : "name : " + endpoint.getName()) + " for sending the message"));
                }
                endpoint.send(synMessageContext);
            } else {
                this.informFailure(synMessageContext);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking the Endpoint as failed, because all child endpoints has been failed");
            }
            this.setActive(false, synMessageContext);
            this.informFailure(synMessageContext);
        }
    }

    public void updateSession(MessageContext responseMsgCtx, List endpointList, boolean isClusteringEnable) {
        Endpoint endpoint = null;
        if (isClusteringEnable) {
            String epNameObj = (String)endpointList.remove(0);
            for (Endpoint ep : this.endpoints) {
                String name;
                if (ep == null || (name = ep instanceof IndirectEndpoint ? ((IndirectEndpoint)ep).getKey() : ep.getName()) == null || !name.equals(epNameObj)) continue;
                endpoint = ep;
                break;
            }
        } else {
            endpoint = (Endpoint)endpointList.remove(0);
        }
        if (endpoint != null) {
            this.dispatcher.updateSession(responseMsgCtx, this.dispatcherContext, endpoint);
            if (endpoint instanceof SALoadbalanceEndpoint) {
                ((SALoadbalanceEndpoint)endpoint).updateSession(responseMsgCtx, endpointList, isClusteringEnable);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean isActive(MessageContext synMessageContext) {
        boolean active;
        Endpoint endpoint = this.dispatcher.getEndpoint(synMessageContext, this.dispatcherContext);
        if (endpoint == null) {
            active = this.endpointContext.isActive();
            if (!active && this.endpoints != null) {
                for (Endpoint ep : this.endpoints) {
                    if (ep == null || !(active = ep.isActive(synMessageContext))) continue;
                    this.endpointContext.setActive(active);
                }
            }
        } else {
            active = endpoint.isActive(synMessageContext);
            if (active) {
                this.endpointContext.setActive(active);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SALoadbalanceEndpoint with name '" + this.getName() + "' is in " + (active ? "active" : "inactive") + " state"));
        }
        return active;
    }

    @Override
    public void setActive(boolean active, MessageContext synMessageContext) {
        this.endpointContext.setActive(active);
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        Object o = synMessageContext.getProperty(FIRST_MESSAGE_IN_SESSION);
        if (o != null && Boolean.TRUE.equals(o)) {
            this.dispatcher.unbind(synMessageContext, this.dispatcherContext);
            this.send(synMessageContext);
        } else {
            this.informFailure(synMessageContext);
        }
    }

    private void informFailure(MessageContext synMessageContext) {
        log.warn((Object)"Failed to send using the selected endpoint, becasue it is inactive");
        if (this.parentEndpoint != null) {
            this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
        } else {
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }
}

