/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.List;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadbalanceEndpoint
implements Endpoint {
    private static final Log log = LogFactory.getLog(LoadbalanceEndpoint.class);
    private String name = null;
    private List<Endpoint> endpoints = null;
    private LoadbalanceAlgorithm algorithm = null;
    private boolean failover = true;
    private Endpoint parentEndpoint = null;
    private final EndpointContext endpointContext = new EndpointContext();
    private final AlgorithmContext algorithmContext = new AlgorithmContext();

    @Override
    public void send(MessageContext synMessageContext) {
        Endpoint endpoint;
        String endPointName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Load-balance Endpoint");
        }
        boolean isClusteringEnable = false;
        org.apache.axis2.context.MessageContext axisMC = ((Axis2MessageContext)synMessageContext).getAxis2MessageContext();
        ConfigurationContext cc = axisMC.getConfigurationContext();
        ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
        if (clusterManager != null && clusterManager.getContextManager() != null) {
            isClusteringEnable = true;
        }
        if ((endPointName = this.getName()) == null) {
            if (isClusteringEnable) {
                log.warn((Object)"In a clustering environment , the endpoint  name should be specifiedeven for anonymous endpoints. Otherwise , the clustering would not be functioned correctly if there are more than one anonymous endpoints. ");
            }
            endPointName = "AnonymousEndpoint";
        }
        if (isClusteringEnable) {
            if (this.endpointContext.getConfigurationContext() == null) {
                this.endpointContext.setConfigurationContext(cc);
                this.endpointContext.setContextID(endPointName);
            }
            if (this.algorithmContext.getConfigurationContext() == null) {
                this.algorithmContext.setConfigurationContext(cc);
                this.algorithmContext.setContextID(endPointName);
            }
        }
        if ((endpoint = this.algorithm.getNextEndpoint(synMessageContext, this.algorithmContext)) != null) {
            if (this.failover) {
                synMessageContext.getEnvelope().build();
            }
            endpoint.send(synMessageContext);
        } else {
            this.setActive(false, synMessageContext);
            if (this.parentEndpoint != null) {
                this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
            } else {
                Object o = synMessageContext.getFaultStack().pop();
                if (o != null) {
                    ((FaultHandler)o).handleFault(synMessageContext);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean isActive(MessageContext synMessageContext) {
        boolean active = this.endpointContext.isActive();
        if (!active && this.endpoints != null) {
            for (Endpoint endpoint : this.endpoints) {
                if (!endpoint.isActive(synMessageContext)) continue;
                active = true;
                this.endpointContext.setActive(true);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint  '" + this.name + "' is in state ' " + active + " '"));
        }
        return active;
    }

    @Override
    public void setActive(boolean active, MessageContext synMessageContext) {
        this.endpointContext.setActive(active);
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        if (this.failover) {
            this.send(synMessageContext);
        } else {
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }
}

