/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class EndpointContext {
    private static final Log log = LogFactory.getLog(EndpointContext.class);
    private static final String ACTIVE = "active";
    private static final String RECOVER_ON = "recover_on";
    private static final String UNDERSCORE_STRING = "_";
    private boolean active = true;
    private long recoverOn = Long.MAX_VALUE;
    private ConfigurationContext configCtx;
    private String activePropertyKey;
    private String recoverOnPropertyKey;
    private boolean isClusteringEnable = false;

    public boolean isActive() {
        Object value;
        if (this.isClusteringEnable) {
            if (this.activePropertyKey == null || "".equals(this.activePropertyKey)) {
                this.handleException("Cannot find the required key to find the shared state of 'active' attribute");
            }
            if ((value = this.configCtx.getPropertyNonReplicable(this.activePropertyKey)) == null) {
                return true;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        } else {
            return this.active;
        }
        this.handleException("Unsupported object type for value" + value);
        throw new SynapseException("Invalid states in endpoint context");
    }

    public synchronized void setActive(boolean active) {
        if (this.isClusteringEnable) {
            this.setAndReplicateState(this.activePropertyKey, active);
        } else {
            this.active = active;
        }
    }

    public long getRecoverOn() {
        Object value;
        if (this.isClusteringEnable) {
            if (this.recoverOnPropertyKey == null || "".equals(this.recoverOnPropertyKey)) {
                this.handleException("Cannot find the required key to find the shared state of 'recoveOn' attribute");
            }
            if ((value = this.configCtx.getPropertyNonReplicable(this.recoverOnPropertyKey)) == null) {
                return Long.MAX_VALUE;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String) {
                try {
                    return Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    return Long.MAX_VALUE;
                }
            }
        } else {
            return this.recoverOn;
        }
        this.handleException("Unsupported object type for value" + value);
        throw new SynapseException("Invalid states in endpoint context");
    }

    public void setRecoverOn(long recoverOn) {
        if (this.isClusteringEnable) {
            this.setAndReplicateState(this.recoverOnPropertyKey, recoverOn);
        } else {
            this.recoverOn = recoverOn;
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    public void setConfigurationContext(ConfigurationContext configCtx) {
        if (configCtx == null) {
            this.handleException("The ConfigurationContext cannot be null when system in a cluster environment");
        }
        this.configCtx = configCtx;
        this.isClusteringEnable = true;
    }

    public void setContextID(String contextID) {
        if (contextID == null || "".equals(contextID)) {
            this.handleException("The Context ID cannot be null when system in a cluster environment");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(contextID);
        buffer.append(UNDERSCORE_STRING);
        String prefix = buffer.toString();
        this.recoverOnPropertyKey = prefix + RECOVER_ON;
        this.activePropertyKey = prefix + ACTIVE;
    }

    private void setAndReplicateState(String key, Object value) {
        if (this.configCtx != null && key != null && value != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property with key : " + key + " value : " + value));
                }
                this.configCtx.setProperty(key, value);
                Replicator.replicate((AbstractContext)this.configCtx, (String[])new String[]{key});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property with key : " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                this.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }

    protected void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

