/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.statistics.impl.EndPointStatisticsStack;

public class DefaultEndpoint
extends FaultHandler
implements Endpoint {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String name = null;
    private EndpointDefinition endpoint = null;
    private Endpoint parentEndpoint = null;

    public EndpointDefinition getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointDefinition endpoint) {
        this.endpoint = endpoint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public boolean isActive(MessageContext synMessageContext) {
        return true;
    }

    public synchronized void setActive(boolean active, MessageContext synMessageContext) {
    }

    public void send(MessageContext synCtx) {
        boolean statisticsEnable;
        String endPointName;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Default Endpoint");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if ((endPointName = this.getName()) == null) {
            endPointName = "AnonymousEndpoint";
        }
        boolean bl = statisticsEnable = 1 == this.endpoint.getStatisticsState();
        if (statisticsEnable) {
            EndPointStatisticsStack endPointStatisticsStack = null;
            Object statisticsStackObj = synCtx.getProperty("synapse.endpoint.stats");
            if (statisticsStackObj == null) {
                endPointStatisticsStack = new EndPointStatisticsStack();
                synCtx.setProperty("synapse.endpoint.stats", endPointStatisticsStack);
            } else if (statisticsStackObj instanceof EndPointStatisticsStack) {
                endPointStatisticsStack = (EndPointStatisticsStack)statisticsStackObj;
            }
            if (endPointStatisticsStack != null) {
                boolean isFault = synCtx.getEnvelope().getBody().hasFault();
                endPointStatisticsStack.put(endPointName, System.currentTimeMillis(), !synCtx.isResponse(), statisticsEnable, isFault);
            }
        }
        if (synCtx.getTo() != null && synCtx.getTo().getAddress() != null && traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Sending message to endpoint : " + endPointName + " resolves to address = " + synCtx.getTo().getAddress());
            this.traceOrDebug(traceOn, "SOAPAction: " + (synCtx.getSoapAction() != null ? synCtx.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Envelope : \n" + synCtx.getEnvelope()));
            }
        }
        synCtx.pushFaultHandler(this);
        synCtx.setProperty("processed_endpoint", this);
        synCtx.getEnvironment().send(this.endpoint, synCtx);
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public void onFault(MessageContext synCtx) {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.onChildEndpointFail(this, synCtx);
        } else {
            Stack faultStack = synCtx.getFaultStack();
            if (!faultStack.isEmpty()) {
                ((FaultHandler)faultStack.pop()).handleFault(synCtx);
            }
        }
    }

    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.endpoint.getTraceState() == 1 || this.endpoint.getTraceState() == 2 && msgCtx.getTracingState() == 1;
    }

    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || this.log.isDebugEnabled();
    }

    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }
}

