/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.statistics.impl.EndPointStatisticsStack;

public class AddressEndpoint
extends DefaultEndpoint {
    private final EndpointContext endpointContext = new EndpointContext();

    public boolean isActive(MessageContext synMessageContext) {
        boolean active = this.endpointContext.isActive();
        if (!active) {
            long recoverOn = this.endpointContext.getRecoverOn();
            if (System.currentTimeMillis() > recoverOn) {
                active = true;
                this.endpointContext.setActive(true);
                this.endpointContext.setRecoverOn(0L);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AddressEndpoint with name '" + this.getName() + "' is in " + (active ? "active" : "inactive") + " state"));
        }
        return active;
    }

    public synchronized void setActive(boolean active, MessageContext synMessageContext) {
        if (!active) {
            EndpointDefinition endpoint = this.getEndpoint();
            if (endpoint.getSuspendOnFailDuration() != -1L) {
                this.endpointContext.setRecoverOn(System.currentTimeMillis() + endpoint.getSuspendOnFailDuration());
            } else {
                this.endpointContext.setRecoverOn(Long.MAX_VALUE);
            }
        }
        this.endpointContext.setActive(active);
    }

    public void send(MessageContext synCtx) {
        EndpointDefinition endpoint;
        boolean statisticsEnable;
        String endPointName;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Address Endpoint");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        boolean isClusteringEnable = false;
        org.apache.axis2.context.MessageContext axisMC = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        ConfigurationContext cc = axisMC.getConfigurationContext();
        ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
        if (clusterManager != null && clusterManager.getContextManager() != null) {
            isClusteringEnable = true;
        }
        if ((endPointName = this.getName()) == null) {
            if (traceOrDebugOn && isClusteringEnable) {
                this.log.warn((Object)"In a clustering environment, the endpoint name should be specified even for anonymous endpoints. Otherwise the clustering would not function properly, if there are more than one anonymous endpoints.");
            }
            endPointName = "AnonymousEndpoint";
        }
        if (isClusteringEnable && this.endpointContext.getConfigurationContext() == null) {
            this.endpointContext.setConfigurationContext(cc);
            this.endpointContext.setContextID(endPointName);
        }
        boolean bl = statisticsEnable = 1 == (endpoint = this.getEndpoint()).getStatisticsState();
        if (statisticsEnable) {
            EndPointStatisticsStack endPointStatisticsStack = null;
            Object statisticsStackObj = synCtx.getProperty("synapse.endpoint.stats");
            if (statisticsStackObj == null) {
                endPointStatisticsStack = new EndPointStatisticsStack();
                synCtx.setProperty("synapse.endpoint.stats", endPointStatisticsStack);
            } else if (statisticsStackObj instanceof EndPointStatisticsStack) {
                endPointStatisticsStack = (EndPointStatisticsStack)statisticsStackObj;
            }
            if (endPointStatisticsStack != null) {
                boolean isFault = synCtx.getEnvelope().getBody().hasFault();
                endPointStatisticsStack.put(endPointName, System.currentTimeMillis(), !synCtx.isResponse(), statisticsEnable, isFault);
            }
        }
        if (endpoint.getAddress() != null && traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Sending message to endpoint : " + endPointName + " resolves to address = " + endpoint.getAddress());
            this.traceOrDebug(traceOn, "SOAPAction: " + (synCtx.getSoapAction() != null ? synCtx.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Envelope : \n" + synCtx.getEnvelope()));
            }
        }
        synCtx.pushFaultHandler(this);
        synCtx.setProperty("processed_endpoint", this);
        synCtx.getEnvironment().send(endpoint, synCtx);
    }

    public void onFault(MessageContext synCtx) {
        this.setActive(false, synCtx);
        super.onFault(synCtx);
    }
}

