/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Map;
import java.util.Stack;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerManager;
import org.apache.synapse.core.axis2.AsyncCallback;

public class TimeoutHandler
extends TimerTask {
    private static final Log log = LogFactory.getLog(TimeoutHandler.class);
    private Map callbackStore = null;
    private Object lock = new Object();
    private boolean alreadyExecuting = false;
    private long globalTimeout = 86400000L;

    public TimeoutHandler(Map callbacks) {
        this.callbackStore = callbacks;
        this.globalTimeout = ServerManager.getInstance().getGlobalTimeoutInterval();
        log.info((Object)("This engine will expire all callbacks after : " + this.globalTimeout / 1000L + " seconds, irrespective of the timeout action, after the specified or optional timeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.alreadyExecuting) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.alreadyExecuting = true;
            try {
                this.processCallbacks();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alreadyExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallbacks() {
        Map map = this.callbackStore;
        synchronized (map) {
            if (this.callbackStore.size() > 0) {
                long currentTime = this.currentTime();
                for (Object key : this.callbackStore.keySet()) {
                    AsyncCallback callback = (AsyncCallback)this.callbackStore.get(key);
                    if (callback.getTimeOutAction() != 100) {
                        if (callback.getTimeOutOn() > currentTime) continue;
                        this.callbackStore.remove(key);
                        if (callback.getTimeOutAction() != 102) continue;
                        MessageContext msgContext = callback.getSynapseOutMsgCtx();
                        msgContext.setProperty("ERROR_CODE", "504");
                        msgContext.setProperty("ERROR_MESSAGE", "Send timeout");
                        Stack faultStack = msgContext.getFaultStack();
                        for (int j = 0; j < faultStack.size(); ++j) {
                            Object o = faultStack.pop();
                            if (!(o instanceof FaultHandler)) continue;
                            ((FaultHandler)o).handleFault(msgContext);
                        }
                        continue;
                    }
                    if (currentTime <= this.globalTimeout + callback.getTimeOutOn()) continue;
                    log.warn((Object)("Expiring message ID : " + key + "; dropping message after " + "global timeout of : " + this.globalTimeout / 1000L + " seconds"));
                    this.callbackStore.remove(key);
                }
            }
        }
    }

    private long currentTime() {
        return System.currentTimeMillis();
    }
}

