/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;

public class SynapseStartUpServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(SynapseStartUpServlet.class);
    private static final String ALREADY_INITED = "synapseAlreadyInited";

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        if (Boolean.TRUE.equals(servletContext.getAttribute(ALREADY_INITED))) {
            return;
        }
        ServerManager serverManager = ServerManager.getInstance();
        String synHome = this.loadParameter(servletConfig, "synapse.home", false);
        if (synHome == null) {
            log.info((Object)"synapse.home not set; using web application root as default value");
            String webinfPath = servletContext.getRealPath("WEB-INF");
            if (webinfPath == null || !webinfPath.endsWith("WEB-INF")) {
                this.handleException("Unable to determine web application root directory");
            } else {
                synHome = webinfPath.substring(0, webinfPath.length() - 7);
                log.info((Object)("Setting synapse.home to : " + synHome));
            }
        }
        serverManager.setSynapseHome(synHome);
        serverManager.setSynapseXMLPath(this.loadParameter(servletConfig, "synapse.xml", true));
        String resolveRoot = this.loadParameter(servletConfig, "resolve.root", false);
        if (resolveRoot != null) {
            serverManager.setResolveRoot(resolveRoot);
        }
        serverManager.setAxis2Repolocation(this.loadParameter(servletConfig, "axis2.repo", true));
        serverManager.setAxis2Xml(this.loadParameter(servletConfig, "axis2.xml", true));
        serverManager.setServerName(this.loadParameter(servletConfig, "serverName", false));
        serverManager.start();
        servletContext.setAttribute(ALREADY_INITED, (Object)Boolean.TRUE);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        try {
            ServerManager serverManager = ServerManager.getInstance();
            serverManager.stop();
            this.getServletContext().removeAttribute(ALREADY_INITED);
        }
        catch (Exception e) {
            log.error((Object)"Error stopping the Synapse listener manager", (Throwable)e);
        }
    }

    private String loadParameter(ServletConfig servletConfig, String name, boolean required) throws ServletException {
        if (System.getProperty(name) == null) {
            String value = servletConfig.getInitParameter(name);
            log.debug((Object)("Init parameter '" + name + "' : " + value));
            if (value != null && value.trim().length() != 0 || !required) {
                return value;
            }
        } else {
            return System.getProperty(name);
        }
        this.handleException("A valid system property or init parameter '" + name + "' is required");
        return null;
    }

    private void handleException(String message) throws ServletException {
        log.error((Object)message);
        this.log(message);
        throw new ServletException(message);
    }
}

