/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseConfigurationBuilder;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;

public class SynapseInitializationModule
implements Module {
    private static final Log log = LogFactory.getLog(SynapseInitializationModule.class);
    private SynapseConfiguration synCfg;

    public void init(ConfigurationContext configurationContext, AxisModule axisModule) throws AxisFault {
        log.info((Object)("Initializing Synapse at : " + new Date()));
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                String hostname;
                String ipAddr = addr.getHostAddress();
                if (ipAddr != null) {
                    MDC.put((String)"ip", (Object)ipAddr);
                }
                if ((hostname = addr.getHostName()) == null) {
                    hostname = ipAddr;
                }
                MDC.put((String)"host", (Object)hostname);
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to determine hostname or IP address of the server for logging", (Throwable)e);
        }
        log.info((Object)"Loading mediator extensions...");
        configurationContext.getAxisConfiguration().getConfigurator().loadServices();
        log.info((Object)"Initializing the Synapse configuration ...");
        this.synCfg = SynapseInitializationModule.getConfiguration(configurationContext);
        log.info((Object)"Deploying the Synapse service..");
        AxisConfiguration axisCfg = configurationContext.getAxisConfiguration();
        AxisService synapseService = new AxisService("__SynapseService");
        InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
        mediateOperation.setMessageReceiver((MessageReceiver)new SynapseMessageReceiver());
        synapseService.addOperation((AxisOperation)mediateOperation);
        ArrayList<String> transports = new ArrayList<String>();
        transports.add("http");
        transports.add("https");
        synapseService.setExposedTransports(transports);
        axisCfg.addService(synapseService);
        String thisServerName = ServerManager.getInstance().getServerName();
        if (thisServerName == null || thisServerName.equals("")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                thisServerName = addr.getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Could not get local host name", (Throwable)e);
            }
            if (thisServerName == null || thisServerName.equals("")) {
                thisServerName = "localhost";
            }
        }
        log.info((Object)("Synapse server name : " + thisServerName));
        log.info((Object)"Deploying Proxy services...");
        for (ProxyService proxy : this.synCfg.getProxyServices()) {
            List pinnedServers = proxy.getPinnedServers();
            if (pinnedServers != null && !pinnedServers.isEmpty() && !pinnedServers.contains(thisServerName)) {
                log.info((Object)("Server name not in pinned servers list. Not deploying Proxy service : " + proxy.getName()));
                continue;
            }
            proxy.buildAxisService(this.synCfg, axisCfg);
            log.info((Object)("Deployed Proxy service : " + proxy.getName()));
            if (proxy.isStartOnLoad()) continue;
            proxy.stop(this.synCfg);
        }
        log.info((Object)"Synapse initialized successfully...!");
    }

    private static SynapseConfiguration getConfiguration(ConfigurationContext cfgCtx) {
        SynapseConfiguration synapseConfiguration;
        cfgCtx.setProperty("addressing.validateAction", (Object)Boolean.FALSE);
        AxisConfiguration axisConfiguration = cfgCtx.getAxisConfiguration();
        String config = ServerManager.getInstance().getSynapseXMLPath();
        if (config != null) {
            synapseConfiguration = SynapseConfigurationBuilder.getConfiguration(config);
        } else {
            log.warn((Object)"System property or init-parameter 'synapse.xml' is not specified. Using default configuration..");
            synapseConfiguration = SynapseConfigurationBuilder.getDefaultConfiguration();
        }
        synapseConfiguration.setAxisConfiguration(cfgCtx.getAxisConfiguration());
        Parameter synapseCtxParam = new Parameter("synapse.config", null);
        synapseCtxParam.setValue((Object)synapseConfiguration);
        MessageContextCreatorForAxis2.setSynConfig(synapseConfiguration);
        Parameter synapseEnvParam = new Parameter("synapse.env", null);
        Axis2SynapseEnvironment synEnv = new Axis2SynapseEnvironment(cfgCtx, synapseConfiguration);
        synapseEnvParam.setValue((Object)synEnv);
        MessageContextCreatorForAxis2.setSynEnv(synEnv);
        try {
            axisConfiguration.addParameter(synapseCtxParam);
            axisConfiguration.addParameter(synapseEnvParam);
        }
        catch (AxisFault e) {
            String msg = "Could not set parameters 'synapse.config' and/or 'synapse.env'to the Axis2 configuration : " + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
        synapseConfiguration.init(synEnv);
        return synapseConfiguration;
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        this.synCfg.destroy();
    }
}

