/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.core.axis2.TimeoutHandler;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.transport.nhttp.util.ResponseAcceptEncodingProcessor;

public class SynapseCallbackReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(SynapseCallbackReceiver.class);
    private Map<String, AxisCallback> callbackStore = Collections.synchronizedMap(new HashMap());

    public SynapseCallbackReceiver(SynapseConfiguration synCfg) {
        ServerManager.getInstance().setCallbackStore(this.callbackStore);
        TimeoutHandler timeoutHandler = new TimeoutHandler(this.callbackStore);
        Timer timeOutTimer = synCfg.getSynapseTimer();
        long timeoutHandlerInterval = ServerManager.getInstance().getTimeoutHandlerInterval();
        timeOutTimer.schedule((TimerTask)timeoutHandler, 0L, timeoutHandlerInterval);
    }

    public void addCallback(String MsgID, AxisCallback callback) {
        this.callbackStore.put(MsgID, callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Callback added. Total callbacks waiting for : " + this.callbackStore.size()));
        }
    }

    public void receive(org.apache.axis2.context.MessageContext messageCtx) throws AxisFault {
        String messageID = null;
        if (messageCtx.getOptions() != null && messageCtx.getOptions().getRelatesTo() != null) {
            RelatesTo relatesTo;
            Options options = messageCtx.getOptions();
            if (options != null && (relatesTo = options.getRelatesTo()) != null) {
                messageID = relatesTo.getValue();
            }
        } else if (messageCtx.getProperty("MercurySequenceKey") == null) {
            messageID = (String)messageCtx.getProperty("synapse.RelatesToForPox");
        }
        if (messageID != null) {
            RelatesTo[] relates;
            AxisCallback callback = this.callbackStore.remove(messageID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Callback removed. Pending callbacks count : " + this.callbackStore.size()));
            }
            if ((relates = messageCtx.getRelationships()) != null && relates.length > 1) {
                this.removeDuplicateRelatesTo(messageCtx, relates);
            }
            if (callback != null) {
                this.handleMessage(messageCtx, ((AsyncCallback)callback).getSynapseOutMsgCtx());
            } else {
                log.warn((Object)("Synapse received a response for the request with message Id : " + messageID + " But a callback is not registered (anymore) to process this response"));
            }
        } else if (!messageCtx.isPropertyTrue("SC_ACCEPTED")) {
            log.warn((Object)"Synapse received a response message without a message Id");
        }
    }

    private void handleMessage(org.apache.axis2.context.MessageContext response, MessageContext synapseOutMsgCtx) throws AxisFault {
        Object o = response.getProperty("sending_fault");
        if (o != null && Boolean.TRUE.equals(o)) {
            SOAPFault fault;
            SOAPEnvelope envelope;
            Stack faultStack = synapseOutMsgCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty() && (envelope = response.getEnvelope()) != null && (fault = envelope.getBody().getFault()) != null) {
                SOAPFaultReason reason;
                Exception e = fault.getException();
                if (e == null && (reason = fault.getReason()) != null) {
                    e = new Exception(reason.getText());
                }
                synapseOutMsgCtx.setProperty("ERROR_CODE", "503");
                SOAPFaultReason faultReason = fault.getReason();
                if (faultReason != null) {
                    synapseOutMsgCtx.setProperty("ERROR_MESSAGE", faultReason.getText());
                }
                if (fault.getException() != null) {
                    synapseOutMsgCtx.setProperty("ERROR_EXCEPTION", fault.getException());
                }
                ((FaultHandler)faultStack.pop()).handleFault(synapseOutMsgCtx, e);
            }
        } else {
            Stack faultStack = synapseOutMsgCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty() && faultStack.peek() instanceof Endpoint) {
                faultStack.pop();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Synapse received an asynchronous response message");
                log.debug((Object)("Received To: " + (response.getTo() != null ? response.getTo().getAddress() : "null")));
                log.debug((Object)("SOAPAction: " + (response.getSoapAction() != null ? response.getSoapAction() : "null")));
                log.debug((Object)("WSA-Action: " + (response.getWSAAction() != null ? response.getWSAAction() : "null")));
                String[] cids = response.getAttachmentMap().getAllContentIDs();
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        log.debug((Object)("Attachment : " + cid));
                    }
                }
                log.debug((Object)("Body : \n" + response.getEnvelope()));
            }
            org.apache.axis2.context.MessageContext axisOutMsgCtx = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
            ResponseAcceptEncodingProcessor.process((org.apache.axis2.context.MessageContext)response, (org.apache.axis2.context.MessageContext)axisOutMsgCtx);
            response.setServiceContext(null);
            response.setOperationContext(axisOutMsgCtx.getOperationContext());
            response.setAxisMessage(axisOutMsgCtx.getAxisOperation().getMessage("Out"));
            response.setServerSide(true);
            response.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
            response.setProperty("TRANSPORT_OUT", axisOutMsgCtx.getProperty("TRANSPORT_OUT"));
            response.setProperty("OutTransportInfo", axisOutMsgCtx.getProperty("OutTransportInfo"));
            response.setTransportIn(axisOutMsgCtx.getTransportIn());
            response.setTransportOut(axisOutMsgCtx.getTransportOut());
            response.setDoingREST(axisOutMsgCtx.isDoingREST());
            if (axisOutMsgCtx.isDoingMTOM()) {
                response.setDoingMTOM(true);
                response.setProperty("enableMTOM", (Object)"true");
            }
            if (axisOutMsgCtx.isDoingSwA()) {
                response.setDoingSwA(true);
                response.setProperty("enableSwA", (Object)"true");
            }
            response.setProperty("messageType", axisOutMsgCtx.getProperty("messageType"));
            if (axisOutMsgCtx.isSOAP11() != response.isSOAP11()) {
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(response);
                } else {
                    SOAPUtils.convertSOAP11toSOAP12(response);
                }
            }
            if (axisOutMsgCtx.getMessageID() != null) {
                response.setRelationships(new RelatesTo[]{new RelatesTo(axisOutMsgCtx.getMessageID())});
            }
            response.setReplyTo(axisOutMsgCtx.getReplyTo());
            response.setFaultTo(axisOutMsgCtx.getFaultTo());
            if (axisOutMsgCtx.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
                response.setProperty("FORCE_SC_ACCEPTED", (Object)"true");
            }
            Axis2MessageContext synapseInMessageContext = new Axis2MessageContext(response, synapseOutMsgCtx.getConfiguration(), synapseOutMsgCtx.getEnvironment());
            synapseInMessageContext.setResponse(true);
            synapseInMessageContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            synapseInMessageContext.setTracingState(synapseOutMsgCtx.getTracingState());
            for (Object key : synapseOutMsgCtx.getPropertyKeySet()) {
                synapseInMessageContext.setProperty((String)key, synapseOutMsgCtx.getProperty((String)key));
            }
            try {
                synapseOutMsgCtx.getEnvironment().injectMessage(synapseInMessageContext);
            }
            catch (SynapseException syne) {
                Stack stack = synapseInMessageContext.getFaultStack();
                if (stack != null && !stack.isEmpty()) {
                    ((FaultHandler)stack.pop()).handleFault(synapseInMessageContext, syne);
                }
                log.error((Object)("Synapse encountered an exception, No error handlers found - [Message Dropped]\n" + syne.getMessage()));
            }
        }
    }

    private void removeDuplicateRelatesTo(org.apache.axis2.context.MessageContext mc, RelatesTo[] relates) {
        int insertPos = 0;
        RelatesTo[] newRelates = new RelatesTo[relates.length];
        for (RelatesTo current : relates) {
            boolean found = false;
            for (int j = 0; j < newRelates.length && j < insertPos; ++j) {
                if (!newRelates[j].equals(current) && !newRelates[j].getValue().equals(current.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newRelates[insertPos++] = current;
        }
        RelatesTo[] trimmedRelates = new RelatesTo[insertPos];
        System.arraycopy(newRelates, 0, trimmedRelates, 0, insertPos);
        mc.setRelationships(trimmedRelates);
    }
}

