/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.CustomURIResolver;
import org.apache.synapse.core.axis2.CustomWSDLLocator;
import org.apache.synapse.core.axis2.ProxyServiceMessageReceiver;
import org.apache.synapse.core.axis2.ResourceMap;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.PolicyInfo;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyService {
    private static final Log log = LogFactory.getLog(ProxyService.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private final Log serviceLog;
    private String name;
    private String description;
    private ArrayList transports;
    private List pinnedServers = new ArrayList();
    private String targetEndpoint = null;
    private String targetInSequence = null;
    private String targetOutSequence = null;
    private String targetFaultSequence = null;
    private Endpoint targetInLineEndpoint = null;
    private SequenceMediator targetInLineInSequence = null;
    private SequenceMediator targetInLineOutSequence = null;
    private SequenceMediator targetInLineFaultSequence = null;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String wsdlKey;
    private URI wsdlURI;
    private Object inLineWSDL;
    private ResourceMap resourceMap;
    private List<PolicyInfo> policies = new ArrayList<PolicyInfo>();
    private List<String> serviceLevelPolicies = new ArrayList<String>();
    private List<String> inMessagePolicies = new ArrayList<String>();
    private List<String> outMessagePolicies = new ArrayList<String>();
    private boolean wsRMEnabled = false;
    private boolean wsSecEnabled = false;
    private boolean startOnLoad = true;
    private boolean running = false;
    public static final String ALL_TRANSPORTS = "all";
    private int statisticsState = 2;
    protected int traceState = 2;

    public ProxyService(String name) {
        this.name = name;
        this.serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + name));
    }

    public AxisService buildAxisService(SynapseConfiguration synCfg, AxisConfiguration axisCfg) {
        AxisService proxyService;
        block67: {
            this.auditInfo("Building Axis service for Proxy service : " + this.name);
            proxyService = null;
            if (this.trace()) {
                trace.info((Object)("Loading the WSDL : " + (this.wsdlKey != null ? " key = " + this.wsdlKey : (this.wsdlURI != null ? " URI = " + this.wsdlURI : " <Inlined>"))));
            }
            ByteArrayInputStream wsdlInputStream = null;
            OMElement wsdlElement = null;
            boolean wsdlFound = false;
            if (this.wsdlKey != null) {
                synCfg.getEntryDefinition(this.wsdlKey);
                Object keyObject = synCfg.getEntry(this.wsdlKey);
                if (keyObject instanceof OMElement) {
                    wsdlElement = (OMElement)keyObject;
                }
                wsdlFound = true;
            } else if (this.inLineWSDL != null) {
                wsdlElement = (OMElement)this.inLineWSDL;
                wsdlFound = true;
            } else if (this.wsdlURI != null) {
                try {
                    URL url = this.wsdlURI.toURL();
                    OMNode node = SynapseConfigUtils.getOMElementFromURL(url.toString());
                    if (node instanceof OMElement) {
                        wsdlElement = (OMElement)node;
                    }
                    wsdlFound = true;
                }
                catch (MalformedURLException e) {
                    this.handleException("Malformed URI for wsdl", e);
                }
                catch (IOException e) {
                    this.handleException("Error reading from wsdl URI", e);
                }
            } else {
                if (this.trace()) {
                    trace.info((Object)"Did not find a WSDL. Assuming a POX or Legacy service");
                }
                proxyService = new AxisService();
                InOutAxisOperation mediateOperation = new InOutAxisOperation(new QName("mediate"));
                proxyService.addOperation((AxisOperation)mediateOperation);
            }
            if (wsdlElement != null) {
                OMNamespace wsdlNamespace = wsdlElement.getNamespace();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    if (this.trace()) {
                        trace.info((Object)"Serializing wsdlElement found to build an Axis2 service");
                    }
                    wsdlElement.serialize((OutputStream)baos);
                    wsdlInputStream = new ByteArrayInputStream(baos.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Error converting to a StreamSource", e);
                }
                if (wsdlInputStream != null) {
                    try {
                        if (this.trace()) {
                            trace.info((Object)("WSDL Namespace is : " + wsdlNamespace.getNamespaceURI()));
                        }
                        if (wsdlNamespace != null) {
                            boolean isWSDL11 = false;
                            WSDL20ToAxisServiceBuilder wsdlToAxisServiceBuilder = null;
                            if ("http://www.w3.org/ns/wsdl".equals(wsdlNamespace.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL20ToAxisServiceBuilder((InputStream)wsdlInputStream, null, null);
                            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder((InputStream)wsdlInputStream);
                                isWSDL11 = true;
                            } else {
                                this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                            }
                            if (wsdlToAxisServiceBuilder == null) {
                                throw new SynapseException("Could not get the WSDL to Axis Service Builder");
                            }
                            wsdlToAxisServiceBuilder.setBaseUri(this.wsdlURI != null ? this.wsdlURI.toString() : ServerManager.getInstance().getSynapseHome());
                            if (this.trace()) {
                                trace.info((Object)"Setting up custom resolvers");
                            }
                            if (this.resourceMap != null) {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomURIResolver(this.resourceMap, synCfg));
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSLD4JResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : "", this.resourceMap, synCfg));
                                }
                            } else {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomURIResolver());
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSLD4JResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : ""));
                                }
                            }
                            if (this.trace()) {
                                trace.info((Object)"Populating Axis2 service using WSDL");
                                if (trace.isTraceEnabled()) {
                                    trace.trace((Object)("WSDL : " + wsdlElement.toString()));
                                }
                            }
                            proxyService = wsdlToAxisServiceBuilder.populateService();
                            proxyService.getEndpoints().clear();
                            break block67;
                        }
                        this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                    }
                    catch (AxisFault af) {
                        this.handleException("Error building service from WSDL", (Exception)((Object)af));
                    }
                    catch (IOException ioe) {
                        this.handleException("Error reading WSDL", ioe);
                    }
                }
            } else if (wsdlFound) {
                this.handleException("Couldn't build the proxy service : " + this.name + ". Unable to locate the specified WSDL to build the service");
            }
        }
        if (proxyService == null) {
            throw new SynapseException("Could not create a proxy service");
        }
        proxyService.setName(this.name);
        if (this.description != null) {
            proxyService.setDocumentation(this.description);
        }
        if (this.transports != null && this.transports.size() != 0) {
            if (this.trace()) {
                trace.info((Object)("Exposing transports : " + this.transports));
            }
            proxyService.setExposedTransports((List)this.transports);
        }
        if (this.trace() && this.parameters.size() > 0) {
            trace.info((Object)("Setting service parameters : " + this.parameters));
        }
        Iterator<Object> i$ = this.parameters.keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String name = o = i$.next();
            Object value = this.parameters.get(name);
            Parameter p = new Parameter();
            p.setName(name);
            p.setValue(value);
            try {
                proxyService.addParameter(p);
            }
            catch (AxisFault af) {
                this.handleException("Error setting parameter : " + name + "" + "to proxy service as a Parameter", (Exception)((Object)af));
            }
        }
        if (!this.policies.isEmpty()) {
            for (PolicyInfo pi : this.policies) {
                AxisOperation op;
                if (pi.isServicePolicy()) {
                    proxyService.getPolicyInclude().addPolicyElement(3, this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                    continue;
                }
                if (pi.isOperationPolicy()) {
                    op = proxyService.getOperation(pi.getOperation());
                    if (op != null) {
                        op.getPolicyInclude().addPolicyElement(4, this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                        continue;
                    }
                    this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                    continue;
                }
                if (pi.isMessagePolicy()) {
                    if (pi.getOperation() != null) {
                        op = proxyService.getOperation(pi.getOperation());
                        if (op != null) {
                            op.getMessage(pi.getMessageLable()).getPolicyInclude().addPolicyElement(16, this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                            continue;
                        }
                        this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                        continue;
                    }
                    Iterator itr = proxyService.getOperations();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (!(obj instanceof AxisOperation) || obj instanceof OutOnlyAxisOperation && pi.getType() == 1 || obj instanceof InOnlyAxisOperation && pi.getType() == 2) continue;
                        AxisMessage message = ((AxisOperation)obj).getMessage(pi.getMessageLable());
                        message.getPolicyInclude().addPolicyElement(5, this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                    }
                    continue;
                }
                this.handleException("Undefined Policy type");
            }
        }
        ProxyServiceMessageReceiver msgRcvr = new ProxyServiceMessageReceiver();
        msgRcvr.setName(this.name);
        msgRcvr.setProxy(this);
        Iterator iter = proxyService.getOperations();
        while (iter.hasNext()) {
            AxisOperation op = (AxisOperation)iter.next();
            op.setMessageReceiver((MessageReceiver)msgRcvr);
        }
        try {
            this.auditInfo("Adding service " + this.name + " to the Axis2 configuration");
            axisCfg.addService(proxyService);
            this.setRunning(true);
        }
        catch (AxisFault axisFault) {
            try {
                if (axisCfg.getService(proxyService.getName()) != null) {
                    if (this.trace()) {
                        trace.info((Object)("Removing service " + this.name + " due to error : " + axisFault.getMessage()));
                    }
                    axisCfg.removeService(proxyService.getName());
                }
            }
            catch (AxisFault ignore) {
                // empty catch block
            }
            this.handleException("Error adding Proxy service to the Axis2 engine", (Exception)((Object)axisFault));
        }
        if (this.wsRMEnabled) {
            this.auditInfo("WS-Reliable messaging is enabled for service : " + this.name);
            try {
                proxyService.engageModule(axisCfg.getModule("Mercury"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS RM module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        if (this.wsSecEnabled) {
            this.auditInfo("WS-Security is enabled for service : " + this.name);
            try {
                proxyService.engageModule(axisCfg.getModule("rampart"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS Sec module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        this.auditInfo("Successfully created the Axis2 service for Proxy service : " + this.name);
        return proxyService;
    }

    private Policy getPolicyFromKey(String key, SynapseConfiguration synCfg) {
        synCfg.getEntryDefinition(key);
        return PolicyEngine.getPolicy((InputStream)SynapseConfigUtils.getStreamSource(synCfg.getEntry(key)).getInputStream());
    }

    public void start(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            Parameter param = axisConfig.getParameter("synapse.env");
            if (param != null && param.getValue() instanceof SynapseEnvironment) {
                SynapseEnvironment env = (SynapseEnvironment)param.getValue();
                if (this.targetInLineInSequence != null) {
                    this.targetInLineInSequence.init(env);
                }
                if (this.targetInLineOutSequence != null) {
                    this.targetInLineOutSequence.init(env);
                }
                if (this.targetInLineFaultSequence != null) {
                    this.targetInLineFaultSequence.init(env);
                }
            } else {
                this.auditWarn("Unable to find the SynapseEnvironment. Components of the proxy service may not be initialized");
            }
            AxisService as = axisConfig.getServiceForActivation(this.getName());
            as.setActive(true);
            axisConfig.notifyObservers(3, as);
            this.setRunning(true);
            this.auditInfo("Started the proxy service : " + this.name);
        } else {
            this.auditWarn("Unable to start proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    public void stop(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            if (this.targetInLineInSequence != null) {
                this.targetInLineInSequence.destroy();
            }
            if (this.targetInLineOutSequence != null) {
                this.targetInLineOutSequence.destroy();
            }
            if (this.targetInLineFaultSequence != null) {
                this.targetInLineFaultSequence.destroy();
            }
            try {
                AxisService as = axisConfig.getService(this.getName());
                if (as != null) {
                    as.setActive(false);
                    axisConfig.notifyObservers(2, as);
                }
                this.setRunning(false);
                this.auditInfo("Stopped the proxy service : " + this.name);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error stopping the proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        } else {
            this.auditWarn("Unable to stop proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    private void handleException(String msg) {
        this.serviceLog.error((Object)msg);
        log.error((Object)msg);
        if (this.trace()) {
            trace.error((Object)msg);
        }
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Exception e) {
        this.serviceLog.error((Object)msg);
        log.error((Object)msg, (Throwable)e);
        if (this.trace()) {
            trace.error((Object)(msg + " :: " + e.getMessage()));
        }
        throw new SynapseException(msg, e);
    }

    private void auditInfo(String message) {
        log.info((Object)message);
        this.serviceLog.info((Object)message);
        if (this.trace()) {
            trace.info((Object)message);
        }
    }

    private void auditWarn(String message) {
        log.warn((Object)message);
        this.serviceLog.warn((Object)message);
        if (this.trace()) {
            trace.warn((Object)message);
        }
    }

    private boolean trace() {
        return this.traceState == 1;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList getTransports() {
        return this.transports;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map<String, Object> getParameterMap() {
        return this.parameters;
    }

    public void setTransports(ArrayList transports) {
        this.transports = transports;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public String getTargetInSequence() {
        return this.targetInSequence;
    }

    public void setTargetInSequence(String targetInSequence) {
        this.targetInSequence = targetInSequence;
    }

    public String getTargetOutSequence() {
        return this.targetOutSequence;
    }

    public void setTargetOutSequence(String targetOutSequence) {
        this.targetOutSequence = targetOutSequence;
    }

    public String getWSDLKey() {
        return this.wsdlKey;
    }

    public void setWSDLKey(String wsdlKey) {
        this.wsdlKey = wsdlKey;
    }

    public List<String> getServiceLevelPolicies() {
        return this.serviceLevelPolicies;
    }

    public void addServiceLevelPolicy(String serviceLevelPolicy) {
        this.serviceLevelPolicies.add(serviceLevelPolicy);
    }

    public boolean isWsRMEnabled() {
        return this.wsRMEnabled;
    }

    public void setWsRMEnabled(boolean wsRMEnabled) {
        this.wsRMEnabled = wsRMEnabled;
    }

    public boolean isWsSecEnabled() {
        return this.wsSecEnabled;
    }

    public void setWsSecEnabled(boolean wsSecEnabled) {
        this.wsSecEnabled = wsSecEnabled;
    }

    public boolean isStartOnLoad() {
        return this.startOnLoad;
    }

    public void setStartOnLoad(boolean startOnLoad) {
        this.startOnLoad = startOnLoad;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getStatisticsState() {
        return this.statisticsState;
    }

    public void setStatisticsState(int statisticsState) {
        this.statisticsState = statisticsState;
    }

    public int getTraceState() {
        return this.traceState;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    public String getTargetFaultSequence() {
        return this.targetFaultSequence;
    }

    public void setTargetFaultSequence(String targetFaultSequence) {
        this.targetFaultSequence = targetFaultSequence;
    }

    public Object getInLineWSDL() {
        return this.inLineWSDL;
    }

    public void setInLineWSDL(Object inLineWSDL) {
        this.inLineWSDL = inLineWSDL;
    }

    public URI getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(URI wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public Endpoint getTargetInLineEndpoint() {
        return this.targetInLineEndpoint;
    }

    public void setTargetInLineEndpoint(Endpoint targetInLineEndpoint) {
        this.targetInLineEndpoint = targetInLineEndpoint;
    }

    public SequenceMediator getTargetInLineInSequence() {
        return this.targetInLineInSequence;
    }

    public void setTargetInLineInSequence(SequenceMediator targetInLineInSequence) {
        this.targetInLineInSequence = targetInLineInSequence;
    }

    public SequenceMediator getTargetInLineOutSequence() {
        return this.targetInLineOutSequence;
    }

    public void setTargetInLineOutSequence(SequenceMediator targetInLineOutSequence) {
        this.targetInLineOutSequence = targetInLineOutSequence;
    }

    public SequenceMediator getTargetInLineFaultSequence() {
        return this.targetInLineFaultSequence;
    }

    public void setTargetInLineFaultSequence(SequenceMediator targetInLineFaultSequence) {
        this.targetInLineFaultSequence = targetInLineFaultSequence;
    }

    public List getPinnedServers() {
        return this.pinnedServers;
    }

    public void setPinnedServers(List pinnedServers) {
        this.pinnedServers = pinnedServers;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public List<String> getInMessagePolicies() {
        return this.inMessagePolicies;
    }

    public void setInMessagePolicies(List<String> inMessagePolicies) {
        this.inMessagePolicies = inMessagePolicies;
    }

    public void addInMessagePolicy(String messagePolicy) {
        this.inMessagePolicies.add(messagePolicy);
    }

    public List<String> getOutMessagePolicies() {
        return this.outMessagePolicies;
    }

    public void setOutMessagePolicies(List<String> outMessagePolicies) {
        this.outMessagePolicies = outMessagePolicies;
    }

    public void addOutMessagePolicy(String messagePolicy) {
        this.outMessagePolicies.add(messagePolicy);
    }

    public List<PolicyInfo> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyInfo> policies) {
        this.policies = policies;
    }

    public void addPolicyInfo(PolicyInfo pi) {
        this.policies.add(pi);
    }
}

