/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2MessageContext
implements MessageContext {
    private SynapseConfiguration synCfg = null;
    private SynapseEnvironment synEnv = null;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> localEntries = new HashMap<String, Object>();
    private Stack<FaultHandler> faultStack = new Stack();
    private org.apache.axis2.context.MessageContext axis2MessageContext = null;
    private boolean response = false;
    private boolean faultResponse = false;
    private int tracingState = 2;
    private Log serviceLog = null;

    @Override
    public SynapseConfiguration getConfiguration() {
        return this.synCfg;
    }

    @Override
    public void setConfiguration(SynapseConfiguration synCfg) {
        this.synCfg = synCfg;
    }

    @Override
    public SynapseEnvironment getEnvironment() {
        return this.synEnv;
    }

    @Override
    public void setEnvironment(SynapseEnvironment synEnv) {
        this.synEnv = synEnv;
    }

    @Override
    public Map getContextEntries() {
        return this.localEntries;
    }

    @Override
    public void setContextEntries(Map<String, Object> entries) {
        this.localEntries = entries;
    }

    @Override
    public Mediator getMainSequence() {
        Object o = this.localEntries.get("main");
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator main = this.getConfiguration().getMainSequence();
        this.localEntries.put("main", main);
        return main;
    }

    @Override
    public Mediator getFaultSequence() {
        Object o = this.localEntries.get("fault");
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator fault = this.getConfiguration().getFaultSequence();
        this.localEntries.put("fault", fault);
        return fault;
    }

    @Override
    public Mediator getSequence(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator m = this.getConfiguration().getSequence(key);
        this.localEntries.put(key, m);
        return m;
    }

    @Override
    public Endpoint getEndpoint(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Endpoint e = this.getConfiguration().getEndpoint(key);
        this.localEntries.put(key, e);
        return e;
    }

    @Override
    public Object getEntry(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Entry) {
            return ((Entry)o).getValue();
        }
        Object e = this.getConfiguration().getEntry(key);
        if (e != null) {
            this.localEntries.put(key, e);
            return e;
        }
        this.getConfiguration().getEntryDefinition(key);
        return this.getConfiguration().getEntry(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
        if ("RESPONSE".equals(key) && this.getAxis2MessageContext().getOperationContext() != null) {
            this.getAxis2MessageContext().getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
    }

    @Override
    public Set getPropertyKeySet() {
        return this.properties.keySet();
    }

    public Axis2MessageContext(org.apache.axis2.context.MessageContext axisMsgCtx, SynapseConfiguration synCfg, SynapseEnvironment synEnv) {
        this.setAxis2MessageContext(axisMsgCtx);
        this.synCfg = synCfg;
        this.synEnv = synEnv;
        this.pushFaultHandler(new MediatorFaultHandler(synCfg.getFaultSequence()));
    }

    @Override
    public EndpointReference getFaultTo() {
        return this.axis2MessageContext.getFaultTo();
    }

    @Override
    public void setFaultTo(EndpointReference reference) {
        this.axis2MessageContext.setFaultTo(reference);
    }

    @Override
    public EndpointReference getFrom() {
        return this.axis2MessageContext.getFrom();
    }

    @Override
    public void setFrom(EndpointReference reference) {
        this.axis2MessageContext.setFrom(reference);
    }

    @Override
    public SOAPEnvelope getEnvelope() {
        return this.axis2MessageContext.getEnvelope();
    }

    @Override
    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.axis2MessageContext.setEnvelope(envelope);
    }

    @Override
    public String getMessageID() {
        return this.axis2MessageContext.getMessageID();
    }

    @Override
    public void setMessageID(String string) {
        this.axis2MessageContext.setMessageID(string);
    }

    @Override
    public RelatesTo getRelatesTo() {
        return this.axis2MessageContext.getRelatesTo();
    }

    @Override
    public void setRelatesTo(RelatesTo[] reference) {
        this.axis2MessageContext.setRelationships(reference);
    }

    @Override
    public EndpointReference getReplyTo() {
        return this.axis2MessageContext.getReplyTo();
    }

    @Override
    public void setReplyTo(EndpointReference reference) {
        this.axis2MessageContext.setReplyTo(reference);
    }

    @Override
    public EndpointReference getTo() {
        return this.axis2MessageContext.getTo();
    }

    @Override
    public void setTo(EndpointReference reference) {
        this.axis2MessageContext.setTo(reference);
    }

    @Override
    public void setWSAAction(String actionURI) {
        this.axis2MessageContext.setWSAAction(actionURI);
    }

    @Override
    public String getWSAAction() {
        return this.axis2MessageContext.getWSAAction();
    }

    @Override
    public void setWSAMessageID(String messageID) {
        this.axis2MessageContext.setWSAMessageId(messageID);
    }

    @Override
    public String getWSAMessageID() {
        return this.axis2MessageContext.getMessageID();
    }

    @Override
    public String getSoapAction() {
        return this.axis2MessageContext.getSoapAction();
    }

    @Override
    public void setSoapAction(String string) {
        this.axis2MessageContext.setSoapAction(string);
    }

    @Override
    public boolean isDoingMTOM() {
        return this.axis2MessageContext.isDoingMTOM();
    }

    @Override
    public boolean isDoingSWA() {
        return this.axis2MessageContext.isDoingSwA();
    }

    @Override
    public void setDoingMTOM(boolean b) {
        this.axis2MessageContext.setDoingMTOM(b);
    }

    @Override
    public void setDoingSWA(boolean b) {
        this.axis2MessageContext.setDoingSwA(b);
    }

    @Override
    public boolean isDoingPOX() {
        return this.axis2MessageContext.isDoingREST();
    }

    @Override
    public void setDoingPOX(boolean b) {
        this.axis2MessageContext.setDoingREST(b);
    }

    @Override
    public boolean isDoingGET() {
        return "GET".equals(this.axis2MessageContext.getProperty("HTTP_METHOD")) && this.axis2MessageContext.isDoingREST();
    }

    @Override
    public void setDoingGET(boolean b) {
        if (b) {
            this.axis2MessageContext.setDoingREST(b);
            this.axis2MessageContext.setProperty("HTTP_METHOD", (Object)"GET");
        } else {
            this.axis2MessageContext.removeProperty("HTTP_METHOD");
        }
    }

    @Override
    public boolean isSOAP11() {
        return this.axis2MessageContext.isSOAP11();
    }

    @Override
    public void setResponse(boolean b) {
        this.response = b;
        this.axis2MessageContext.setProperty("synapse.isresponse", (Object)b);
    }

    @Override
    public boolean isResponse() {
        Object o = this.properties.get("RESPONSE");
        return o != null && o instanceof String && ((String)o).equalsIgnoreCase("true") || this.response;
    }

    @Override
    public void setFaultResponse(boolean b) {
        this.faultResponse = b;
    }

    @Override
    public boolean isFaultResponse() {
        return this.faultResponse;
    }

    @Override
    public int getTracingState() {
        return this.tracingState;
    }

    @Override
    public void setTracingState(int tracingState) {
        this.tracingState = tracingState;
    }

    @Override
    public Stack getFaultStack() {
        return this.faultStack;
    }

    @Override
    public void pushFaultHandler(FaultHandler fault) {
        this.faultStack.push(fault);
    }

    @Override
    public Log getServiceLog() {
        if (this.serviceLog != null) {
            return this.serviceLog;
        }
        String serviceName = (String)this.getProperty("proxy.name");
        if (serviceName != null && this.synCfg.getProxyService(serviceName) != null) {
            this.serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + serviceName));
            return this.serviceLog;
        }
        this.serviceLog = LogFactory.getLog((String)"SERVICE_LOGGER.".substring(0, "SERVICE_LOGGER.".length() - 1));
        return this.serviceLog;
    }

    public void setServiceLog(Log serviceLog) {
        this.serviceLog = serviceLog;
    }

    public org.apache.axis2.context.MessageContext getAxis2MessageContext() {
        return this.axis2MessageContext;
    }

    public void setAxis2MessageContext(org.apache.axis2.context.MessageContext axisMsgCtx) {
        this.axis2MessageContext = axisMsgCtx;
        Boolean resp = (Boolean)axisMsgCtx.getProperty("synapse.isresponse");
        if (resp != null) {
            this.response = resp;
        }
    }

    public void setPaused(boolean value) {
        this.axis2MessageContext.setPaused(value);
    }

    public boolean isPaused() {
        return this.axis2MessageContext.isPaused();
    }

    public boolean isServerSide() {
        return this.axis2MessageContext.isServerSide();
    }

    public void setServerSide(boolean value) {
        this.axis2MessageContext.setServerSide(value);
    }

    public String toString() {
        SOAPBody soapBody;
        SOAPHeader soapHeader;
        StringBuffer sb = new StringBuffer();
        String separator = "\n";
        if (this.getTo() != null) {
            sb.append("To : ").append(this.getTo().getAddress());
        } else {
            sb.append("To : ");
        }
        if (this.getFrom() != null) {
            sb.append(separator).append("From : ").append(this.getFrom().getAddress());
        }
        if (this.getWSAAction() != null) {
            sb.append(separator).append("WSAction : ").append(this.getWSAAction());
        }
        if (this.getSoapAction() != null) {
            sb.append(separator).append("SOAPAction : ").append(this.getSoapAction());
        }
        if (this.getReplyTo() != null) {
            sb.append(separator).append("ReplyTo : ").append(this.getReplyTo().getAddress());
        }
        if (this.getMessageID() != null) {
            sb.append(separator).append("MessageID : ").append(this.getMessageID());
        }
        if ((soapHeader = this.getEnvelope().getHeader()) != null) {
            sb.append(separator).append("Headers : ");
            Iterator iter = soapHeader.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                    sb.append(separator).append("\t").append(headerBlock.getLocalName()).append(" : ").append(headerBlock.getText());
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                OMElement headerElem = (OMElement)o;
                sb.append(separator).append("\t").append(headerElem.getLocalName()).append(" : ").append(headerElem.getText());
            }
        }
        if ((soapBody = this.getEnvelope().getBody()) != null) {
            sb.append(separator).append("Body : ").append(soapBody.toString());
        }
        return sb.toString();
    }
}

