/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class WSDLEndpointSerializer
extends EndpointSerializer {
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        OMElement wsdlDoc;
        String uri;
        String portName;
        if (!(endpoint instanceof WSDLEndpoint)) {
            throw new SynapseException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)endpoint;
        String name = wsdlEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        OMElement wsdlElement = this.fac.createOMElement("wsdl", SynapseConstants.SYNAPSE_OMNAMESPACE);
        String serviceName = wsdlEndpoint.getServiceName();
        if (serviceName != null) {
            wsdlElement.addAttribute("service", serviceName, null);
        }
        if ((portName = wsdlEndpoint.getPortName()) != null) {
            wsdlElement.addAttribute("port", portName, null);
        }
        if ((uri = wsdlEndpoint.getWsdlURI()) != null) {
            wsdlElement.addAttribute("uri", uri, null);
        }
        if ((wsdlDoc = wsdlEndpoint.getWsdlDoc()) != null) {
            wsdlElement.addChild((OMNode)wsdlDoc);
        }
        EndpointDefinition epDefinition = wsdlEndpoint.getEndpoint();
        this.serializeCommonEndpointProperties(epDefinition, wsdlElement);
        this.serializeSpecificEndpointProperties(epDefinition, wsdlElement);
        endpointElement.addChild((OMNode)wsdlElement);
        return endpointElement;
    }

    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
    }
}

