/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.ServerManager;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.WSDL11EndpointBuilder;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class WSDLEndpointFactory
extends EndpointFactory {
    private static WSDLEndpointFactory instance = new WSDLEndpointFactory();

    private WSDLEndpointFactory() {
    }

    public static WSDLEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement wsdlElement;
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            wsdlEndpoint.setName(name.getAttributeValue());
        }
        if ((wsdlElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"))) != null) {
            EndpointDefinition endpoint = null;
            String serviceName = wsdlElement.getAttributeValue(new QName("service"));
            String portName = wsdlElement.getAttributeValue(new QName("port"));
            String wsdlURI = wsdlElement.getAttributeValue(new QName("uri"));
            wsdlEndpoint.setServiceName(serviceName);
            wsdlEndpoint.setPortName(portName);
            if (wsdlURI != null) {
                wsdlEndpoint.setWsdlURI(wsdlURI.trim());
                try {
                    OMElement omElement;
                    OMNamespace ns;
                    OMNode wsdlOM = SynapseConfigUtils.getOMElementFromURL(new URL(wsdlURI).toString());
                    if (wsdlOM != null && wsdlOM instanceof OMElement && (ns = (omElement = (OMElement)wsdlOM).getNamespace()) != null) {
                        String nsUri = omElement.getNamespace().getNamespaceURI();
                        if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                            endpoint = new WSDL11EndpointBuilder().createEndpointDefinitionFromWSDL(wsdlURI.trim(), omElement, serviceName, portName);
                        } else if ("http://www.w3.org/ns/wsdl".equals(nsUri)) {
                            WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported");
                        }
                    }
                }
                catch (Exception e) {
                    WSDLEndpointFactory.handleException("Couldn't create endpoint from the given WSDL URI : " + e.getMessage(), e);
                }
            }
            OMElement definitionElement = wsdlElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
            if (endpoint == null && definitionElement != null) {
                wsdlEndpoint.setWsdlDoc(definitionElement);
                String resolveRoot = ServerManager.getInstance().getResolveRoot();
                String baseUri = "file:./";
                if (resolveRoot != null) {
                    baseUri = resolveRoot.trim();
                }
                if (!baseUri.endsWith(File.separator)) {
                    baseUri = baseUri + File.separator;
                }
                endpoint = new WSDL11EndpointBuilder().createEndpointDefinitionFromWSDL(baseUri, definitionElement, serviceName, portName);
            }
            OMElement descriptionElement = wsdlElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "description"));
            if (endpoint == null && descriptionElement != null) {
                wsdlEndpoint.setWsdlDoc(descriptionElement);
                WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported.");
            }
            if (endpoint != null) {
                this.extractCommonEndpointProperties(endpoint, wsdlElement);
                this.extractSpecificEndpointProperties(endpoint, wsdlElement);
                wsdlEndpoint.setEndpoint(endpoint);
            } else {
                WSDLEndpointFactory.handleException("WSDL is not specified for WSDL endpoint.");
            }
        }
        return wsdlEndpoint;
    }

    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
    }
}

