/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class SALoadbalanceEndpointFactory
extends EndpointFactory {
    private static SALoadbalanceEndpointFactory instance = new SALoadbalanceEndpointFactory();

    private SALoadbalanceEndpointFactory() {
    }

    public static SALoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement loadbalanceElement;
        SALoadbalanceEndpoint loadbalanceEndpoint = new SALoadbalanceEndpoint();
        OMElement sessionElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
        if (sessionElement != null) {
            String type = sessionElement.getAttributeValue(new QName("type"));
            if (type.equalsIgnoreCase("soap")) {
                SoapSessionDispatcher soapDispatcher = new SoapSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(soapDispatcher);
            } else if (type.equalsIgnoreCase("http")) {
                HttpSessionDispatcher httpDispatcher = new HttpSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(httpDispatcher);
            } else if (type.equalsIgnoreCase("simpleClientSession")) {
                SimpleClientSessionDispatcher csDispatcher = new SimpleClientSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(csDispatcher);
            }
        } else {
            SALoadbalanceEndpointFactory.handleException("Session affinity endpoints should have a session element in the configuration.");
        }
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            loadbalanceEndpoint.setName(name.getAttributeValue());
        }
        if ((loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"))) != null) {
            ArrayList<Endpoint> endpoints = this.getEndpoints(loadbalanceElement, loadbalanceEndpoint);
            loadbalanceEndpoint.setEndpoints(endpoints);
            LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, endpoints);
            loadbalanceEndpoint.setAlgorithm(algorithm);
            return loadbalanceEndpoint;
        }
        return null;
    }
}

