/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class LoadbalanceEndpointFactory
extends EndpointFactory {
    private static LoadbalanceEndpointFactory instance = new LoadbalanceEndpointFactory();

    private LoadbalanceEndpointFactory() {
    }

    public static LoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (loadbalanceElement != null) {
            LoadbalanceEndpoint loadbalanceEndpoint = new LoadbalanceEndpoint();
            OMAttribute name = epConfig.getAttribute(new QName("", "name"));
            if (name != null) {
                loadbalanceEndpoint.setName(name.getAttributeValue());
            }
            ArrayList<Endpoint> endpoints = this.getEndpoints(loadbalanceElement, loadbalanceEndpoint);
            loadbalanceEndpoint.setEndpoints(endpoints);
            LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, endpoints);
            loadbalanceEndpoint.setAlgorithm(algorithm);
            String failover = loadbalanceElement.getAttributeValue(new QName("failover"));
            if (failover != null && failover.equalsIgnoreCase("false")) {
                loadbalanceEndpoint.setFailover(false);
            }
            return loadbalanceEndpoint;
        }
        return null;
    }
}

