/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.AddressEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public abstract class EndpointSerializer {
    private static Log log = LogFactory.getLog(EndpointSerializer.class);
    protected OMFactory fac;

    public static OMElement getElementFromEndpoint(Endpoint endpoint) {
        return EndpointSerializer.getEndpointSerializer(endpoint).serializeEndpoint(endpoint);
    }

    protected abstract OMElement serializeEndpoint(Endpoint var1);

    protected void serializeCommonEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
        long suspendDuration;
        if (endpointDefinition.getStatisticsState() == 1) {
            element.addAttribute(this.fac.createOMAttribute("statistics", null, "enable"));
        } else if (endpointDefinition.getStatisticsState() == 0) {
            element.addAttribute(this.fac.createOMAttribute("statistics", null, "disable"));
        }
        if (endpointDefinition.getTraceState() == 1) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "enable"));
        } else if (endpointDefinition.getStatisticsState() == 0) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "disable"));
        }
        if (endpointDefinition.isUseSwa()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "swa"));
        } else if (endpointDefinition.isUseMTOM()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "mtom"));
        }
        if (endpointDefinition.getCharSetEncoding() != null) {
            element.addAttribute(this.fac.createOMAttribute("encoding", null, endpointDefinition.getCharSetEncoding()));
        }
        if (endpointDefinition.isAddressingOn()) {
            OMElement addressing = this.fac.createOMElement("enableAddressing", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getAddressingVersion() != null) {
                addressing.addAttribute(this.fac.createOMAttribute("version", null, endpointDefinition.getAddressingVersion()));
            }
            if (endpointDefinition.isUseSeparateListener()) {
                addressing.addAttribute(this.fac.createOMAttribute("separateListener", null, "true"));
            }
            element.addChild((OMNode)addressing);
        }
        if (endpointDefinition.isReliableMessagingOn()) {
            OMElement rm = this.fac.createOMElement("enableRM", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsRMPolicyKey() != null) {
                rm.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsRMPolicyKey()));
            }
            element.addChild((OMNode)rm);
        }
        if (endpointDefinition.isSecurityOn()) {
            OMElement sec = this.fac.createOMElement("enableSec", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsSecPolicyKey() != null) {
                sec.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsSecPolicyKey()));
            }
            element.addChild((OMNode)sec);
        }
        if (endpointDefinition.getTimeoutAction() != 100) {
            OMElement timeout = this.fac.createOMElement("timeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
            element.addChild((OMNode)timeout);
            OMElement duration = this.fac.createOMElement("duration", SynapseConstants.SYNAPSE_OMNAMESPACE);
            duration.setText(Long.toString(endpointDefinition.getTimeoutDuration() / 1000L));
            timeout.addChild((OMNode)duration);
            OMElement action = this.fac.createOMElement("action", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getTimeoutAction() == 101) {
                action.setText("discard");
            } else if (endpointDefinition.getTimeoutAction() == 102) {
                action.setText("fault");
            }
            timeout.addChild((OMNode)action);
        }
        if ((suspendDuration = endpointDefinition.getSuspendOnFailDuration()) != -1L) {
            OMElement suspendElement = this.fac.createOMElement("suspendDurationOnFailure", SynapseConstants.SYNAPSE_OMNAMESPACE);
            suspendElement.setText(Long.toString(suspendDuration / 1000L));
            element.addChild((OMNode)suspendElement);
        }
    }

    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
    }

    protected void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    public static EndpointSerializer getEndpointSerializer(Endpoint endpoint) {
        if (endpoint instanceof AddressEndpoint) {
            return new AddressEndpointSerializer();
        }
        if (endpoint instanceof WSDLEndpoint) {
            return new WSDLEndpointSerializer();
        }
        if (endpoint instanceof IndirectEndpoint) {
            return new IndirectEndpointSerializer();
        }
        if (endpoint instanceof LoadbalanceEndpoint) {
            return new LoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof SALoadbalanceEndpoint) {
            return new SALoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof FailoverEndpoint) {
            return new FailoverEndpointSerializer();
        }
        throw new SynapseException("Serializer for endpoint " + endpoint.getClass().toString() + " is not defined.");
    }
}

