/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.AddressEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointFactory;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointFactory;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointFactory
implements XMLToObjectMapper {
    private static Log log = LogFactory.getLog(EndpointFactory.class);

    public static Endpoint getEndpointFromElement(OMElement elem, boolean isAnonymous) {
        return EndpointFactory.getEndpointFactory(elem).createEndpoint(elem, isAnonymous);
    }

    @Override
    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.createEndpoint((OMElement)om, false);
        }
        EndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    protected abstract Endpoint createEndpoint(OMElement var1, boolean var2);

    protected void extractCommonEndpointProperties(EndpointDefinition definition, OMElement elem) {
        OMElement suspendElement;
        OMElement timeout;
        OMElement wsRm;
        OMElement wsSec;
        OMElement wsAddr;
        OMAttribute optimize = elem.getAttribute(new QName("", "optimize"));
        OMAttribute encoding = elem.getAttribute(new QName("", "encoding"));
        OMAttribute statistics = elem.getAttribute(new QName("", "statistics"));
        if (statistics != null && statistics.getAttributeValue() != null) {
            String statisticsValue = statistics.getAttributeValue();
            if ("enable".equals(statisticsValue)) {
                definition.setStatisticsState(1);
            } else if ("disable".equals(statisticsValue)) {
                definition.setStatisticsState(0);
            }
        } else {
            definition.setStatisticsState(2);
        }
        OMAttribute trace = elem.getAttribute(new QName("", "trace"));
        if (trace != null && trace.getAttributeValue() != null) {
            String traceValue = trace.getAttributeValue();
            if ("enable".equals(traceValue)) {
                definition.setTraceState(1);
            } else if ("disable".equals(traceValue)) {
                definition.setTraceState(0);
            }
        } else {
            definition.setTraceState(2);
        }
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                definition.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                definition.setUseSwa(true);
            }
        }
        if (encoding != null && encoding.getAttributeValue() != null) {
            definition.setCharSetEncoding(encoding.getAttributeValue());
        }
        if ((wsAddr = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            String useSepList;
            definition.setAddressingOn(true);
            OMAttribute version = wsAddr.getAttribute(new QName("version"));
            if (version != null && version.getAttributeValue() != null) {
                String versionValue = version.getAttributeValue().trim().toLowerCase();
                if ("final".equals(versionValue) || "submission".equals(versionValue)) {
                    definition.setAddressingVersion(version.getAttributeValue());
                } else {
                    EndpointFactory.handleException("Unknown value for the addressing version. Possible values for the addressing version are 'final' and 'submission' only.");
                }
            }
            if ((useSepList = wsAddr.getAttributeValue(new QName("separateListener"))) != null && "true".equals(useSepList.trim().toLowerCase())) {
                definition.setUseSeparateListener(true);
            }
        }
        if ((wsSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            definition.setSecurityOn(true);
            OMAttribute policy = wsSec.getAttribute(new QName("", "policy"));
            if (policy != null) {
                definition.setWsSecPolicyKey(policy.getAttributeValue());
            }
        }
        if ((wsRm = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM"))) != null) {
            definition.setReliableMessagingOn(true);
            OMAttribute policy = wsRm.getAttribute(new QName("", "policy"));
            if (policy != null) {
                definition.setWsRMPolicyKey(policy.getAttributeValue());
            }
        }
        if ((timeout = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                try {
                    long timeoutSeconds = Long.parseLong(d.trim());
                    definition.setTimeoutDuration(timeoutSeconds * 1000L);
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("Endpoint timeout duration expected as a number but was not a number");
                }
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "action"))) != null && action.getText() != null) {
                String actionString = action.getText();
                if ("discard".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(101);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else if ("fault".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(102);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else {
                    EndpointFactory.handleException("Invalid timeout action, action : " + actionString + " is not supported");
                }
            }
        }
        if ((suspendElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"))) != null && suspendElement.getText() != null) {
            try {
                long suspendDuration = Long.parseLong(suspendElement.getText().trim());
                definition.setSuspendOnFailDuration(suspendDuration * 1000L);
            }
            catch (NumberFormatException e) {
                EndpointFactory.handleException("The suspend duration should be specified as a valid number :: " + e.getMessage(), e);
            }
        }
    }

    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
    }

    private static EndpointFactory getEndpointFactory(OMElement configElement) {
        if (configElement.getAttribute(new QName("key")) != null) {
            return IndirectEndpointFactory.getInstance();
        }
        OMElement addressElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"));
        if (addressElement != null) {
            return AddressEndpointFactory.getInstance();
        }
        OMElement wsdlElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"));
        if (wsdlElement != null) {
            return WSDLEndpointFactory.getInstance();
        }
        OMElement defaultElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"));
        if (defaultElement != null) {
            return DefaultEndpointFactory.getInstance();
        }
        OMElement lbElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (lbElement != null) {
            OMElement sessionElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
            if (sessionElement != null) {
                return SALoadbalanceEndpointFactory.getInstance();
            }
            return LoadbalanceEndpointFactory.getInstance();
        }
        OMElement foElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "failover"));
        if (foElement != null) {
            return FailoverEndpointFactory.getInstance();
        }
        EndpointFactory.handleException("Invalid endpoint configuration.");
        return null;
    }

    protected ArrayList<Endpoint> getEndpoints(OMElement listEndpointElement, Endpoint parent) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = listEndpointElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT);
        while (iter.hasNext()) {
            OMElement endptElem = (OMElement)iter.next();
            Endpoint endpoint = EndpointFactory.getEndpointFromElement(endptElem, true);
            if (endpoint instanceof IndirectEndpoint) {
                String key = ((IndirectEndpoint)endpoint).getKey();
                if (!keys.contains(key)) {
                    keys.add(key);
                } else {
                    EndpointFactory.handleException("Same endpoint definition cannot be used with in the siblings");
                }
            }
            endpoint.setParentEndpoint(parent);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

