/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class DefaultEndpointSerializer
extends EndpointSerializer {
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof DefaultEndpoint)) {
            throw new SynapseException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        DefaultEndpoint defaultEndpoint = (DefaultEndpoint)endpoint;
        String name = defaultEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        EndpointDefinition epAddress = defaultEndpoint.getEndpoint();
        OMElement defaultElement = this.serializeEndpointDefinition(epAddress);
        endpointElement.addChild((OMNode)defaultElement);
        return endpointElement;
    }

    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
        if ("pox".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if ("get".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if ("soap11".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if ("soap12".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        } else if (endpointDefinition.isForcePOX()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if (endpointDefinition.isForceGET()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if (endpointDefinition.isForceSOAP11()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if (endpointDefinition.isForceSOAP12()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        }
    }

    public OMElement serializeEndpointDefinition(EndpointDefinition endpointDefinition) {
        OMElement element = this.fac.createOMElement("default", SynapseConstants.SYNAPSE_OMNAMESPACE);
        this.serializeCommonEndpointProperties(endpointDefinition, element);
        this.serializeSpecificEndpointProperties(endpointDefinition, element);
        return element;
    }
}

