/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class DefaultEndpointFactory
extends EndpointFactory {
    private static DefaultEndpointFactory instance = new DefaultEndpointFactory();

    protected DefaultEndpointFactory() {
    }

    public static DefaultEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement defaultElement;
        DefaultEndpoint defaultEndpoint = new DefaultEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            defaultEndpoint.setName(name.getAttributeValue());
        }
        if ((defaultElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"))) != null) {
            EndpointDefinition endpoint = this.createEndpointDefinition(defaultElement);
            defaultEndpoint.setEndpoint(endpoint);
        }
        return defaultEndpoint;
    }

    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
        OMAttribute format = elem.getAttribute(new QName("", "format"));
        if (format != null) {
            String forceValue = format.getAttributeValue().trim().toLowerCase();
            if ("pox".equals(forceValue)) {
                definition.setForcePOX(true);
                definition.setFormat("pox");
            } else if ("get".equals(forceValue)) {
                definition.setForceGET(true);
                definition.setFormat("get");
            } else if ("soap11".equals(forceValue)) {
                definition.setForceSOAP11(true);
                definition.setFormat("soap11");
            } else if ("soap12".equals(forceValue)) {
                definition.setForceSOAP12(true);
                definition.setFormat("soap12");
            } else {
                DefaultEndpointFactory.handleException("force value -\"" + forceValue + "\" not yet implemented");
            }
        }
    }

    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        EndpointDefinition endpointDefinition = new EndpointDefinition();
        this.extractCommonEndpointProperties(endpointDefinition, elem);
        this.extractSpecificEndpointProperties(endpointDefinition, elem);
        return endpointDefinition;
    }
}

