/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class AddressEndpointSerializer
extends DefaultEndpointSerializer {
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof AddressEndpoint)) {
            throw new SynapseException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        AddressEndpoint addressEndpoint = (AddressEndpoint)endpoint;
        String name = addressEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        EndpointDefinition epAddress = addressEndpoint.getEndpoint();
        OMElement addressElement = this.serializeEndpointDefinition(epAddress);
        endpointElement.addChild((OMNode)addressElement);
        return endpointElement;
    }

    public OMElement serializeEndpointDefinition(EndpointDefinition endpointDefinition) {
        OMElement element = this.fac.createOMElement("address", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if (endpointDefinition.getAddress() != null) {
            element.addAttribute(this.fac.createOMAttribute("uri", null, endpointDefinition.getAddress()));
        } else {
            this.handleException("Invalid Endpoint. Address is required");
        }
        this.serializeCommonEndpointProperties(endpointDefinition, element);
        this.serializeSpecificEndpointProperties(endpointDefinition, element);
        return element;
    }
}

