/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class AddressEndpointFactory
extends DefaultEndpointFactory {
    private static AddressEndpointFactory instance = new AddressEndpointFactory();

    private AddressEndpointFactory() {
    }

    public static AddressEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement addressElement;
        AddressEndpoint addressEndpoint = new AddressEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            addressEndpoint.setName(name.getAttributeValue());
        }
        if ((addressElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"))) != null) {
            EndpointDefinition endpoint = this.createEndpointDefinition(addressElement);
            addressEndpoint.setEndpoint(endpoint);
        }
        return addressEndpoint;
    }

    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        OMAttribute address = elem.getAttribute(new QName("uri"));
        EndpointDefinition endpointDefinition = new EndpointDefinition();
        if (address != null) {
            endpointDefinition.setAddress(address.getAttributeValue());
        }
        this.extractCommonEndpointProperties(endpointDefinition, elem);
        this.extractSpecificEndpointProperties(endpointDefinition, elem);
        return endpointDefinition;
    }
}

