/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.transform.XSLTMediator;

public class XSLTMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof XSLTMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        XSLTMediator mediator = (XSLTMediator)m;
        OMElement xslt = fac.createOMElement("xslt", synNS);
        if (mediator.getXsltKey() != null) {
            xslt.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getXsltKey()));
        } else {
            this.handleException("Invalid XSLT mediator. XSLT registry key is required");
        }
        XSLTMediatorSerializer.saveTracingState(xslt, mediator);
        if (mediator.getSource() != null && !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(mediator.getSource().toString())) {
            SynapseXPathSerializer.serializeXPath(mediator.getSource(), xslt, "source");
        }
        if (mediator.getTargetPropertyName() != null) {
            xslt.addAttribute(fac.createOMAttribute("target", nullNS, mediator.getTargetPropertyName()));
        }
        this.serializeProperties(xslt, mediator.getProperties());
        List<MediatorProperty> features = mediator.getFeatures();
        if (!features.isEmpty()) {
            for (MediatorProperty mp : features) {
                OMElement prop = fac.createOMElement("feature", synNS, (OMContainer)xslt);
                if (mp.getName() != null) {
                    prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                } else {
                    this.handleException("The Feature name is missing");
                }
                if (mp.getValue() != null) {
                    prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                this.handleException("The Feature value is missing");
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)xslt);
        }
        return xslt;
    }

    public String getMediatorClassName() {
        return XSLTMediator.class.getName();
    }
}

