/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.mediators.eip.Target;

public class TargetSerializer {
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
    private static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeTarget(Target target) {
        OMElement targetElem = fac.createOMElement("target", synNS);
        if (target.getToAddress() != null) {
            targetElem.addAttribute("to", target.getToAddress(), nullNS);
        }
        if (target.getSoapAction() != null) {
            targetElem.addAttribute("soapAction", target.getSoapAction(), nullNS);
        }
        if (target.getSequenceRef() != null) {
            targetElem.addAttribute("sequence", target.getSequenceRef(), nullNS);
        }
        if (target.getEndpointRef() != null) {
            targetElem.addAttribute("endpoint", target.getEndpointRef(), nullNS);
        }
        if (target.getSequence() != null) {
            SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
            serializer.serializeAnonymousSequence(targetElem, target.getSequence());
        }
        if (target.getEndpoint() != null) {
            targetElem.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(target.getEndpoint()));
        }
        return targetElem;
    }
}

