/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.config.xml.AnonymousListMediatorSerializer;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.filters.SwitchMediator;

public class SwitchMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof SwitchMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        SwitchMediator mediator = (SwitchMediator)m;
        OMElement switchMed = fac.createOMElement("switch", synNS);
        SwitchMediatorSerializer.saveTracingState(switchMed, mediator);
        if (mediator.getSource() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getSource(), switchMed, "source");
        } else {
            this.handleException("Invalid switch mediator. Source required");
        }
        Iterator iter = mediator.getCases().iterator();
        while (iter.hasNext()) {
            AnonymousListMediator caseMediator;
            OMElement caseElem = fac.createOMElement("case", synNS);
            SwitchCase aCase = (SwitchCase)iter.next();
            if (aCase.getRegex() != null) {
                caseElem.addAttribute(fac.createOMAttribute("regex", nullNS, aCase.getRegex().pattern()));
            } else {
                this.handleException("Invalid switch case. Regex required");
            }
            if ((caseMediator = aCase.getCaseMediator()) == null) continue;
            new AnonymousListMediatorSerializer().serializeMediator(caseElem, caseMediator);
            switchMed.addChild((OMNode)caseElem);
        }
        SwitchCase defaultCase = mediator.getDefaultCase();
        if (defaultCase != null) {
            OMElement caseDefaultElem = fac.createOMElement("default", synNS);
            AnonymousListMediator caseDefaultMediator = defaultCase.getCaseMediator();
            if (caseDefaultMediator != null) {
                new AnonymousListMediatorSerializer().serializeMediator(caseDefaultElem, caseDefaultMediator);
                switchMed.addChild((OMNode)caseDefaultElem);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)switchMed);
        }
        return switchMed;
    }

    public String getMediatorClassName() {
        return SwitchMediator.class.getName();
    }
}

