/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.Registry;

public class RegistryFactory {
    private static final Log log = LogFactory.getLog(RegistryFactory.class);
    public static final QName PROVIDER_Q = new QName("", "provider");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    public static final QName NAME_Q = new QName("", "name");

    public static Registry createRegistry(OMElement elem) {
        OMAttribute prov = elem.getAttribute(PROVIDER_Q);
        if (prov != null) {
            try {
                Class<?> provider = Class.forName(prov.getAttributeValue());
                Registry registry = (Registry)provider.newInstance();
                registry.init(RegistryFactory.getProperties(elem));
                return registry;
            }
            catch (ClassNotFoundException e) {
                RegistryFactory.handleException("Cannot locate registry provider class : " + prov.getAttributeValue(), e);
            }
            catch (IllegalAccessException e) {
                RegistryFactory.handleException("Error instantiating registry provider : " + prov.getAttributeValue(), e);
            }
            catch (InstantiationException e) {
                RegistryFactory.handleException("Error instantiating registry provider : " + prov.getAttributeValue(), e);
            }
        } else {
            RegistryFactory.handleException("The registry 'provider' attribute is required for a registry definition");
        }
        return null;
    }

    private static Properties getProperties(OMElement elem) {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        Properties props = new Properties();
        while (params.hasNext()) {
            Object o = params.next();
            if (o instanceof OMElement) {
                OMElement prop = (OMElement)o;
                OMAttribute pname = prop.getAttribute(NAME_Q);
                String propertyValue = prop.getText();
                if (pname != null) {
                    if (propertyValue == null) continue;
                    props.setProperty(pname.getAttributeValue(), propertyValue.trim());
                    continue;
                }
                RegistryFactory.handleException("Invalid registry property - property should have a name ");
                continue;
            }
            RegistryFactory.handleException("Invalid registry property");
        }
        return props;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

