/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.PropertyMediatorSerializer;
import org.apache.synapse.config.xml.ResourceMapSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.PolicyInfo;

public class ProxyServiceSerializer {
    private static final Log log = LogFactory.getLog(PropertyMediatorSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeProxy(OMElement parent, ProxyService service) {
        List pinnedServers;
        ArrayList transports;
        OMElement proxy = fac.createOMElement("proxy", synNS);
        if (service.getName() != null) {
            proxy.addAttribute(fac.createOMAttribute("name", nullNS, service.getName()));
        } else {
            ProxyServiceSerializer.handleException("Invalid proxy service. Service name is required");
        }
        String descriptionStr = service.getDescription();
        if (descriptionStr != null) {
            OMElement description = fac.createOMElement("description", synNS);
            description.addChild((OMNode)fac.createOMText(descriptionStr));
            proxy.addChild((OMNode)description);
        }
        if ((transports = service.getTransports()) != null && !transports.isEmpty()) {
            String transportStr = "" + transports.get(0);
            for (int i = 1; i < transports.size(); ++i) {
                transportStr = transportStr + " " + transports.get(i);
            }
            proxy.addAttribute(fac.createOMAttribute("transports", nullNS, transportStr));
        }
        if ((pinnedServers = service.getPinnedServers()) != null && !pinnedServers.isEmpty()) {
            String pinnedServersStr = "" + pinnedServers.get(0);
            for (int i = 1; i < pinnedServers.size(); ++i) {
                pinnedServersStr = pinnedServersStr + " " + pinnedServers.get(i);
            }
            proxy.addAttribute(fac.createOMAttribute("pinnedServers", nullNS, pinnedServersStr));
        }
        if (service.isStartOnLoad()) {
            proxy.addAttribute(fac.createOMAttribute("startOnLoad", nullNS, "true"));
        } else {
            proxy.addAttribute(fac.createOMAttribute("startOnLoad", nullNS, "false"));
        }
        String endpoint = service.getTargetEndpoint();
        OMElement target = fac.createOMElement("target", synNS);
        Endpoint inLineEndpoint = service.getTargetInLineEndpoint();
        if (endpoint != null) {
            target.addAttribute(fac.createOMAttribute("endpoint", nullNS, endpoint));
            proxy.addChild((OMNode)target);
        } else if (inLineEndpoint != null) {
            OMElement epElement = EndpointSerializer.getElementFromEndpoint(inLineEndpoint);
            target.addChild((OMNode)epElement);
            proxy.addChild((OMNode)target);
        }
        String inSeq = service.getTargetInSequence();
        String outSeq = service.getTargetOutSequence();
        String faultSeq = service.getTargetFaultSequence();
        SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
        if (inSeq != null) {
            target.addAttribute(fac.createOMAttribute("inSequence", nullNS, inSeq));
            proxy.addChild((OMNode)target);
        } else {
            SequenceMediator inLineInSeq = service.getTargetInLineInSequence();
            if (inLineInSeq != null) {
                OMElement inSeqElement = serializer.serializeAnonymousSequence(null, inLineInSeq);
                inSeqElement.setLocalName("inSequence");
                target.addChild((OMNode)inSeqElement);
                proxy.addChild((OMNode)target);
            }
        }
        if (outSeq != null) {
            target.addAttribute(fac.createOMAttribute("outSequence", nullNS, outSeq));
            proxy.addChild((OMNode)target);
        } else {
            SequenceMediator inLineOutSeq = service.getTargetInLineOutSequence();
            if (inLineOutSeq != null) {
                OMElement outSeqElement = serializer.serializeAnonymousSequence(null, inLineOutSeq);
                outSeqElement.setLocalName("outSequence");
                target.addChild((OMNode)outSeqElement);
                proxy.addChild((OMNode)target);
            }
        }
        if (faultSeq != null) {
            target.addAttribute(fac.createOMAttribute("faultSequence", nullNS, faultSeq));
            proxy.addChild((OMNode)target);
        } else {
            SequenceMediator inLineFaultSeq = service.getTargetInLineFaultSequence();
            if (inLineFaultSeq != null) {
                OMElement faultSeqElement = serializer.serializeAnonymousSequence(null, inLineFaultSeq);
                faultSeqElement.setLocalName("faultSequence");
                target.addChild((OMNode)faultSeqElement);
                proxy.addChild((OMNode)target);
            }
        }
        String wsdlKey = service.getWSDLKey();
        URI wsdlUri = service.getWsdlURI();
        Object inLineWSDL = service.getInLineWSDL();
        if (wsdlKey != null || wsdlUri != null || inLineWSDL != null) {
            OMElement wsdl = fac.createOMElement("publishWSDL", synNS);
            if (wsdlKey != null) {
                wsdl.addAttribute(fac.createOMAttribute("key", nullNS, wsdlKey));
            } else if (inLineWSDL != null) {
                wsdl.addChild((OMNode)inLineWSDL);
            } else if (wsdlUri != null) {
                wsdl.addAttribute(fac.createOMAttribute("uri", nullNS, wsdlUri.toString()));
            }
            ResourceMapSerializer.serializeResourceMap(wsdl, service.getResourceMap());
            proxy.addChild((OMNode)wsdl);
        }
        for (PolicyInfo pi : service.getPolicies()) {
            OMElement policy = fac.createOMElement("policy", synNS);
            if (pi.getPolicyKey() != null) {
                policy.addAttribute(fac.createOMAttribute("key", nullNS, pi.getPolicyKey()));
            } else {
                ProxyServiceSerializer.handleException("Policy without a key has been found");
            }
            if (pi.getOperation() != null) {
                policy.addAttribute(fac.createOMAttribute("operationName", nullNS, pi.getOperation().getLocalPart()));
                if (pi.getOperation().getNamespaceURI() != null) {
                    policy.addAttribute(fac.createOMAttribute("operationNamespace", nullNS, pi.getOperation().getNamespaceURI()));
                }
            }
            if (pi.getType() != 0) {
                policy.addAttribute(fac.createOMAttribute("type", nullNS, pi.getMessageLable().toLowerCase()));
            }
            proxy.addChild((OMNode)policy);
        }
        for (String propertyName : service.getParameterMap().keySet()) {
            OMElement property = fac.createOMElement("parameter", synNS);
            property.addAttribute(fac.createOMAttribute("name", nullNS, propertyName));
            Object value = service.getParameterMap().get(propertyName);
            if (value == null) continue;
            if (value instanceof String) {
                property.setText(((String)value).trim());
                proxy.addChild((OMNode)property);
                continue;
            }
            if (!(value instanceof OMNode)) continue;
            property.addChild((OMNode)value);
            proxy.addChild((OMNode)property);
        }
        if (service.isWsRMEnabled()) {
            proxy.addChild((OMNode)fac.createOMElement("enableRM", synNS));
        }
        if (service.isWsSecEnabled()) {
            proxy.addChild((OMNode)fac.createOMElement("enableSec", synNS));
        }
        int isEnableStatistics = service.getStatisticsState();
        String statisticsValue = null;
        if (isEnableStatistics == 1) {
            statisticsValue = "enable";
        } else if (isEnableStatistics == 0) {
            statisticsValue = "disable";
        }
        if (statisticsValue != null) {
            proxy.addAttribute(fac.createOMAttribute("statistics", nullNS, statisticsValue));
        }
        int traceState = service.getTraceState();
        String traceValue = null;
        if (traceState == 1) {
            traceValue = "enable";
        } else if (traceState == 0) {
            traceValue = "disable";
        }
        if (traceValue != null) {
            proxy.addAttribute(fac.createOMAttribute("trace", nullNS, traceValue));
        }
        if (parent != null) {
            parent.addChild((OMNode)proxy);
        }
        return proxy;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

