/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.builtin.PropertyMediator;

public class PropertyMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof PropertyMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        PropertyMediator mediator = (PropertyMediator)m;
        OMElement property = fac.createOMElement("property", synNS);
        PropertyMediatorSerializer.saveTracingState(property, mediator);
        if (mediator.getName() != null) {
            property.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
        } else {
            this.handleException("Invalid property mediator. Name is required");
        }
        if (mediator.getValue() != null) {
            property.addAttribute(fac.createOMAttribute("value", nullNS, mediator.getValue()));
        } else if (mediator.getExpression() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getExpression(), property, "expression");
        } else if (mediator.getAction() == 0) {
            this.handleException("Invalid property mediator. Value or expression is required if action is SET");
        }
        if (mediator.getScope() != null) {
            property.addAttribute(fac.createOMAttribute("scope", nullNS, mediator.getScope()));
        }
        if (mediator.getAction() == 1) {
            property.addAttribute(fac.createOMAttribute("action", nullNS, "remove"));
        }
        if (parent != null) {
            parent.addChild((OMNode)property);
        }
        return property;
    }

    public String getMediatorClassName() {
        return PropertyMediator.class.getName();
    }
}

