/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.transform.FaultMediator;

public class FaultMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String SOAP11 = "soap11";
    private static final String SOAP12 = "soap12";
    private static final String POX = "pox";

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        OMElement detail;
        if (!(m instanceof FaultMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        FaultMediator mediator = (FaultMediator)m;
        OMElement fault = fac.createOMElement("makefault", synNS);
        FaultMediatorSerializer.saveTracingState(fault, mediator);
        if (mediator.getSoapVersion() == 1) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, SOAP11));
        } else if (mediator.getSoapVersion() == 2) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, SOAP12));
        } else if (mediator.getSoapVersion() == 3) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, POX));
        }
        OMElement code = fac.createOMElement("code", synNS, (OMContainer)fault);
        if (mediator.getFaultCodeValue() != null) {
            code.addAttribute(fac.createOMAttribute("value", nullNS, mediator.getFaultCodeValue().getPrefix() + ":" + mediator.getFaultCodeValue().getLocalPart()));
            code.declareNamespace(mediator.getFaultCodeValue().getNamespaceURI(), mediator.getFaultCodeValue().getPrefix());
        } else if (mediator.getFaultCodeExpr() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getFaultCodeExpr(), code, "expression");
        } else if (mediator.getSoapVersion() != 3) {
            this.handleException("Fault code is required for a fault mediator unless it is a pox fault");
        }
        OMElement reason = fac.createOMElement("reason", synNS, (OMContainer)fault);
        if (mediator.getFaultReasonValue() != null) {
            reason.addAttribute(fac.createOMAttribute("value", nullNS, mediator.getFaultReasonValue()));
        } else if (mediator.getFaultReasonExpr() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getFaultReasonExpr(), reason, "expression");
        } else if (mediator.getSoapVersion() != 3) {
            this.handleException("Fault reason is required for a fault mediator unless it is a pox fault");
        }
        if (mediator.getFaultNode() != null) {
            OMElement node = fac.createOMElement("node", synNS, (OMContainer)fault);
            node.setText(mediator.getFaultNode().toString());
        }
        if (mediator.getFaultRole() != null) {
            OMElement role = fac.createOMElement("role", synNS, (OMContainer)fault);
            role.setText(mediator.getFaultRole().toString());
        }
        if (mediator.getFaultDetailExpr() != null) {
            detail = fac.createOMElement("detail", synNS, (OMContainer)fault);
            SynapseXPathSerializer.serializeXPath(mediator.getFaultDetailExpr(), detail, "expression");
        } else if (mediator.getFaultDetail() != null) {
            detail = fac.createOMElement("detail", synNS, (OMContainer)fault);
            detail.setText(mediator.getFaultDetail());
        }
        if (parent != null) {
            parent.addChild((OMNode)fault);
        }
        return fault;
    }

    public String getMediatorClassName() {
        return FaultMediator.class.getName();
    }
}

